<?php

use App\Models\Sessions;
use App\Models\Reservation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
Route::namespace('api')->group(function () {
    Route::get('/test/search', 'hotel\HotelControllers@search');
    Route::get('/test/city', 'StaticData@index');
    Route::get('/test/MR', 'StaticData@indexMR');
    Route::get('/test/city', 'StaticData@check');


    Route::get('/images', 'ImagesController@getRand');
    Route::post('/register', 'AuthCountroller@register');
    Route::get('/guest', 'AuthCountroller@guest');
    Route::post('/guest', 'AuthCountroller@guest');


    Route::post('/reset-password', 'AuthCountroller@resetPassword');
    Route::get('/reopt-password/{verification}', 'AuthCountroller@forgetPasswordReOTP');
    Route::post('/otp', 'AuthCountroller@obtCode');
    Route::post('/updatedPassword', 'AuthCountroller@updatedPassword');
    Route::post('/register_otp', 'AuthCountroller@regiestOTP');
    Route::get('/resend/{id}', 'AuthCountroller@resendOTP');
    Route::post('/updated', 'AuthCountroller@updatedUser');
    Route::get('/me', 'AuthCountroller@me')->middleware('CheckAuth');
   Route::prefix('history')->middleware('CheckAuth')->group(function () {
        Route::get('/hotel/{limit}/{type?}', 'UsersHistory@hotel');
        Route::get('/air/{limit}', 'UsersHistory@air');
    });
    Route::get('/test', function ()
    {
        $all = \App\Models\Reservation::all();

        foreach ($all as $a)
        {
            $guest = Sessions::find($a->guest_id);
            $res = Reservation::find($a->id);
            $res->user_id = $guest->client_id;
            $res->save();
        }
    });
    Route::post('hotel/booking_detail', 'HotelController@bookingDetail');

    /*
    Route::prefix('hotel')->middleware('checkGuest')->group(function () {
        Route::get('/', 'HotelController@getCountry');
        Route::get('/city/{code}', 'HotelController@getCity');
        Route::get('/hotel_city/{code}/{is_detailed}', 'HotelController@HotelByCity');
        Route::get('/search', 'HotelController@search');
        Route::post('/prebook', 'HotelController@prebook');
        Route::post('/booking-tbo', 'HotelController@bookingBTO');
        Route::post('/cancel_tbo', 'HotelController@cancel');
        //Route::post('/booking_detail', 'HotelController@bookingDetail');
        Route::post('/HotelDetails', 'HotelController@hotelDetails');
    });
    Route::namespace('Air')->group(function () {
        Route::get('air/airports/{code}', 'DataSenderController@search');
        Route::get('air/test', 'AirControllers@test');
        Route::post('air/GetBookingDetails', 'AirControllers@GetBookingDetails');
        Route::prefix('air')->middleware(['checkGuest','auth.tbo'])->group(function () {
            Route::post('search', 'AirControllers@search');
            Route::post('search/detials', 'AirControllers@searchDetials');
            Route::post('booking', 'AirControllers@booking');
            Route::post('ticket/lcc', 'AirControllers@ticketLcc');
            Route::post('ticket/no-lcc', 'AirControllers@ticketLcc');
        });
    });


    */

    Route::prefix('basic')->group(function () {
        Route::get('/country/{name}', 'BasicDataController@getCountry');
        Route::get('/cities/{country_id}/{name?}', 'BasicDataController@cities');
    });
});


