@extends('admin.layout.index')
@section('title')
    {{ __('messages.static_page') }}
@endsection
@section('css')
    <style>
        .center-test {
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;

        }

        .form-input-test {
            width: 350px;
            padding: 20px;
            background: #fff;
            box-shadow: -3px -3px 7px rgba(94, 104, 121, 0.377),
                3px 3px 7px rgba(94, 104, 121, 0.377);
            margin-bottom: 50px;
            margin-top: 50px;
        }

        .form-input-test img {
            width: 100%;
            margin-bottom: 30px;
            position: relative;
            max-height: 100%;
            border: 4px solid #fff;

        }

        .form-input-test input {
            display: none;
        }

        .form-input-test label {
            display: block;
            width: 45%;
            height: 45px;
            line-height: 50px;
            text-align: center;
            background: #1172c2;
            color: #fff;
            font-size: 15px;
            font-family: "Open Sans", sans-serif;
            text-transform: Uppercase;
            font-weight: 600;
            border-radius: 5px;
            cursor: pointer;
            margin: auto;
        }
    </style>
@endsection
@section('content')
    <div class="content-header">

    </div>
    <div class="content">
        <div class="col-12">
            <div class="box box-default">
                <div class="box-header with-border">
                    <h4 class="box-title">{{ __('messages.updated-page') }}</h4>
                </div>
                <form method="post" action="{{ route('static.updated', $page->id) }}" enctype="multipart/form-data">
                    <!-- /.box-header -->
                    <div class="box-body">
                        <!-- Nav tabs -->
                        <ul class="nav nav-tabs nav-fill" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link {{ session('back') == null ? 'active' : '' }} {{ session('back') != null && session('back')['open'] == 1 ? 'active' : '' }} "
                                    data-toggle="tab" href="#arabic" role="tab">
                                    <span>
                                        <i class="flag-icon flag-icon-eg mr-1"></i></span>
                                    <span class="hidden-xs-down ml-15">{{ __('messages.lang-ar') }}
                                    </span>
                                    @if (session('back') != null && isset(session('back')['error_ar']))
                                        <span style="color: orangered"><i class="fa fa-times mr-1"></i></span>
                                    @endif

                                </a>
                            </li>
                            <li class="nav-item"><a
                                    class="nav-link {{ session('back') != null && session('back')['open'] == 2 ? 'active' : '' }}"
                                    data-toggle="tab" href="#english" role="tab"><span><i
                                            class="flag-icon flag-icon-gb mr-1"></i></span> <span
                                        class="hidden-xs-down ml-15">{{ __('messages.lang-en') }}</span>
                                    @if (session('back') != null && isset(session('back')['error_en']))
                                        <span style="color: orangered"><i class="fa fa-times mr-1"></i></span>
                                    @endif
                                </a></li>
                        </ul>
                        <!-- Tab panes -->

                        <div class="tab-content tabcontent-border">
                            <div class="tab-pane {{ session('back') == null ? 'active' : '' }} {{ session('back') != null && session('back')['open'] == 1 ? 'active' : '' }} "
                                id="arabic" role="tabpanel">
                                <div class="p-15">
                                    <div class="col-md-12 text-center">
                                        <div class="center-test">
                                            <div class="form-input-test">
                                                <div class="preview">
                                                    @if (!empty($page->cover) && file_exists(public_path() . '/upload/image/' . $page->cover))
                                                        <img id="file-ip-1-preview"
                                                            src="{{ url('upload/image/' . $page->cover) }}">
                                                    @else
                                                        <img id="file-ip-1-preview" src="" style="display: none;">
                                                    @endif
                                                </div>
                                                <label for="file-ip-1"> {{ __('messages.photo') }} : <span
                                                        class="danger">*</span></label>
                                                <input type="file" id="file-ip-1" name="photo"
                                                    onchange="showPreview(event);" accept="image/*">
                                                @if ($errors->has('photo'))
                                                    <span class="help-block">
                                                        <strong class="text-danger">{{ $errors->first('photo') }}</strong>
                                                    </span>
                                                @endif

                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="title_ar"> {{ __('messages.title_ar') }} : <span
                                                        class="danger">*</span> </label>
                                                <input type="text" class="form-control" id="title_ar" name="title_ar"
                                                    value="{{ old('title_ar') != null ? old('title_ar') : $page->title_ar }}">
                                                @if ($errors->has('title_ar'))
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger">{{ $errors->first('title_ar') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="slug_ar">{{ __('messages.slug_ar') }} : <span
                                                        class="danger"></span></label>
                                                <input type="text" name="slug_ar" id="slug_ar"
                                                    value="{{ old('slug_ar') != null ? old('slug_ar') : $page->slug_ar }}"
                                                    {{ $page->change_slug == 1 ? 'disabled' : '' }} class="form-control">
                                                @if ($errors->has('slug_ar'))
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger">{{ $errors->first('slug_ar') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>


                                    <div class="row">

                                        <div class="col-md-12">
                                            <div class="form-group">

                                                <label for="wemailAddress2"> {{ __('messages.body_ar') }} : <span
                                                        class="danger">*</span> </label>
                                                <textarea id="body_ar" name="body_ar" rows="10" cols="80">
                                                    {!! old('body_ar') != null ? old('body_ar') : $page->body_ar !!}
                                                </textarea>
                                                @if ($errors->has('body_ar'))
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger">{{ $errors->first('body_ar') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>

                                    </div>


                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="title_ar"> {{ __('messages.menu') }} : <span
                                                        class="danger">*</span> </label>
                                                <select name="menu" data-placeholder="Type to search menus"
                                                    class="form-control custom-select required select2">
                                                    @if (!empty($menus))
                                                        @foreach ($menus as $name)
                                                            <option value="{{ $name }}"
                                                                @if (old('menu') != null) {{ old('menu') == $name ? 'selected' : '' }}
                                                                @else
                                                                {{ $page->menu == $name ? 'selected' : '' }} @endif>
                                                                {{ $name }}</option>
                                                        @endforeach
                                                    @endif

                                                </select>
                                                @if ($errors->has('menu'))
                                                    <span class="help-block">
                                                        <strong class="text-danger">{{ $errors->first('menu') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="title_ar"> {{ __('messages.notes') }} : <span
                                                        class="danger">*</span> </label>
                                                <p class="danger">{{ __('messages.notesMunes') }}</p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="wemailAddress2"> {{ __('messages.tags_ar') }} : <span
                                                        class="danger">*</span> </label>
                                                <input type="text" class="form-control " name="tags_ar"
                                                    value="{{ old('tags_ar') != null ? old('tags_ar') : $page->tags_ar }}">
                                                @if ($errors->has('tags_ar'))
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger">{{ $errors->first('tags_ar') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="wlastName2"> {{ __('messages.status') }} : <span
                                                        class="danger">*</span> </label>
                                                <select name="enabel" data-placeholder="Type to search cities"
                                                    class="form-control custom-select required">
                                                    <option value="1"
                                                        @if (old('enabel') != null) {{ old('enabel') == 1 ? 'selected' : '' }}
                                                        @else
                                                        {{ $page->enabel == 1 ? 'selected' : '' }} @endif>
                                                        {{ __('messages.isActive') }}</option>
                                                    <option value="0"
                                                        @if (old('enabel') != null) {{ old('enabel') == 0 ? 'selected' : '' }}
                                                        @else
                                                        {{ $page->enabel == 0 ? 'selected' : '' }} @endif>
                                                        {{ __('messages.inActive') }}</option>
                                                </select>
                                                @if ($errors->has('enabel'))
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger">{{ $errors->first('enabel') }}</strong>
                                                    </span>
                                                @endif

                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="arrangment"> {{ __('messages.arrangment') }} : </label>
                                                <input id="arrangment" type="number" class="form-control "
                                                    name="arrangment"
                                                    value="{{ old('arrangment') != null ? old('arrangment') : $page->arrangment }}">
                                                @if ($errors->has('arrangment'))
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger">{{ $errors->first('arrangment') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane {{ session('back') != null && session('back')['open'] == 2 ? 'active' : '' }}"
                                id="english" role="tabpanel">
                                <div class="p-15">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="title_en"> {{ __('messages.title_en') }} : <span
                                                        class="danger"></span> </label>
                                                <input type="text" class="form-control" id="title_en"
                                                    name="title_en"
                                                    value="{{ old('title_en') != null ? old('title_en') : $page->title_en }}">
                                                @if ($errors->has('title_en'))
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger">{{ $errors->first('title_en') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="slug_en">{{ __('messages.slug_en') }} : <span
                                                        class="danger"></span></label>
                                                <input type="text" name="slug_en" id="slug_en"
                                                    {{ $page->change_slug == 1 ? 'disabled' : '' }}
                                                    value="{{ old('slug_en') != null ? old('slug_en') : $page->slug_en }}"
                                                    class="form-control"
                                                    @if ($errors->has('slug_en')) <span class="help-block">
                                                            <strong
                                                                class="text-danger">{{ $errors->first('slug_en') }}</strong>
                                                        </span> @endif
                                                    </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="wemailAddress2"> {{ __('messages.body_en') }} : <span
                                                        class="danger">*</span> </label>
                                                <textarea id="body_en" name="body_en" rows="10" cols="80">
                                                    {!! old('body_en') != null ? old('body_en') : $page->body_en !!}
                                                </textarea>
                                                @if ($errors->has('body_en'))
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger">{{ $errors->first('body_en') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="wemailAddress2"> {{ __('messages.tags_en') }} : <span
                                                        class="danger">*</span> </label>
                                                <input type="text" class="form-control " name="tags_en"
                                                    value="{{ old('tags_en') != null ? old('tags_en') : $page->tags_en }}">
                                                @if ($errors->has('tags_en'))
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger">{{ $errors->first('tags_en') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>
                    <input type="hidden" value="{{ csrf_token() }}" name="_token">
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <button type="submit" class="btn btn-rounded btn-primary btn-outline">
                            <i class="ti-save-alt"></i> Save
                        </button>
                    </div>
                </form>
            </div>
            <!-- /.box -->
        </div>
    </div>


@endsection

@section('js')
    <script>
        $(function() {
            "use strict";

            // Replace the <textarea id="editor1"> with a CKEditor
            // instance, using default configuration.
            CKEDITOR.replace('body_ar', {
                removePlugins: 'scayt,wsc',
                disableNativeSpellChecker: true
            })
            CKEDITOR.replace('body_en', {
                removePlugins: 'scayt,wsc',
                disableNativeSpellChecker: true
            })
            CKEDITOR.replace('body_fr', {
                removePlugins: 'scayt,wsc',
                disableNativeSpellChecker: true
            })
            //bootstrap WYSIHTML5 - text editor
            $('.textarea').wysihtml5();

        });


        function showPreview(event) {
            if (event.target.files.length > 0) {
                console.log('11');
                let src = URL.createObjectURL(event.target.files[0]);
                let preview = document.getElementById("file-ip-1-preview");
                preview.src = src;
                preview.style.display = "block";
            }
        }

        $(document).ready(function() {
            $('.select_2').select2();
        });


        $("#title_ar").on('input', function() {
            var titleValue = $(this).val();
            var slugValue = titleValue.toLowerCase().replace(/\s+/g, '-');
            $("#slug_ar").val(slugValue);
        });
        $("#title_en").on('input', function() {
            var titleValue = $(this).val();
            var slugValue = titleValue.toLowerCase().replace(/\s+/g, '-');
            $("#slug_en").val(slugValue);
        });
        $("#title_fr").on('input', function() {
            var titleValue = $(this).val();
            var slugValue = titleValue.toLowerCase().replace(/\s+/g, '-');
            $("#slug_fr").val(slugValue);
        });
    </script>
@endsection
