! function($) {
    "use strict";

    var SweetAlert = function() {};

    //examples 
    SweetAlert.prototype.init = function() {

            //Basic
            $('#sa-basic').click(function() {
                swal("Here's a message!");
            });

            //A title with a text under
            $('#sa-title').click(function() {
                swal("Here's a message!", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed lorem erat eleifend ex semper, lobortis purus sed.")
            });

            //Success Message
            $('#sa-success').click(function() {
                swal("Good job!", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed lorem erat eleifend ex semper, lobortis purus sed.", "success")
            });

            //Warning Message
            $('.sa-warning').click(function(e) {
                e.preventDefault();
                var url = $(this).data("href");
                var title = $(this).data("title");
                var desc = $(this).data("desc");
                swal({
                    title: title,
                    text: desc,
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: $(this).data("yes"),
                    cancelButtonText: $(this).data("no"),
                    closeOnConfirm: false
                }, function() {
                    window.location.href = url;
                });
            });

            //Parameter
            $('#sa-params').click(function() {
                swal({
                    title: "Are you sure?",
                    text: "You will not be able to recover this imaginary file!",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "Yes, delete it!",
                    cancelButtonText: "No, cancel plx!",
                    closeOnConfirm: false,
                    closeOnCancel: false
                }, function(isConfirm) {
                    if (isConfirm) {
                        swal("Deleted!", "Your imaginary file has been deleted.", "success");
                    } else {
                        swal("Cancelled", "Your imaginary file is safe :)", "error");
                    }
                });
            });

            //Custom Image
            $('#sa-image').click(function() {
                swal({
                    title: "Govinda!",
                    text: "Recently joined twitter",
                    imageUrl: "../../images/avatar.png"
                });
            });

            //Auto Close Timer
            $('#sa-close').click(function() {
                swal({
                    title: "Auto close alert!",
                    text: "I will close in 2 seconds.",
                    timer: 2000,
                    showConfirmButton: false
                });
            });


        },
        //init
        $.SweetAlert = new SweetAlert, $.SweetAlert.Constructor = SweetAlert
}(window.jQuery),

//initializing 
function($) {
    "use strict";
    $.SweetAlert.init()
}(window.jQuery);