<?php

namespace App\Sys\Services;

use App\Models\Sessions;
use App\Sys\Repository\SessionsRepo;
use Carbon\Carbon;

class SessionServices extends Sessions
{

    public $session;

    public function __construct()
    {
        $this->session = new SessionsRepo();
    }


    public function add($data)
    {
        return $this->session->add($data);
    }
    public  function addSession($token ,$new = true)
    {
        if($new == true)
            return $this->session->add($token);




        $check = $this->session->getSessionByToken($token);
        if(($check != null && $check->time_expire == null ) || ($check != null && $check->time_expire > Carbon::now()))
            return $check;


        $this->session->closeAnySessionByToken($token);
        return $this->session->add($token);

    }

    public function updatedToken($data)
    {
        $session = $this->session->getSessionByToken($data['oldToken']);
        if(!empty($session))
            return $this->session->updatedToken($data);


        return $this->session->add($data);
    }

    public function updatedSe($session)
    {
        return $this->session->updatedSearch($session);
    }

    public function checkSessionstime($id)
    {
        $session = $this->session->getSessionById($id);
        if(($session != null && $session->time_expire == null ) || ($session != null && $session->time_expire > Carbon::now()))
            return true;

        return false;

    }

    public  function addSessioninFirstTable($company,$data,$status,$session_id)
    {
        $data['company'] = $company;
        $data['data'] = $data;
        $data['status'] = $status;
        $data['session_id'] = $session_id;
        return $this->session->addSessionFirstTable($data);
    }

    public function addNewToken($company,$key,$value,$session_id,$ex)
    {
        $data['company'] = $company;
        $data['key'] = $key;
        $data['value'] = $value;
        $data['session_id'] = $session_id;
        $data['expired_date'] = $ex;
        return $this->session->AddSessionToken($data);
    }

    public function getFirstRueslteData($id)
    {
        $well =  $this->session->getSessionFirstData($id);
        if(!empty($well))
        {
            $data['status'] = true;
            $data['data']=$well;
            return $data;
        }
        $data['status'] =false;
        $data['data'] = $this->session->NotWell($id);
        return $data;

    }

    public function getTokenBySessionID($session,$key,$company)
    {
        return $this->session->getTokenBySessionID($session,$key,$company);
    }

    public function getFind($session_id)
    {
        return $this->session->getSessionById($session_id);
    }

}
