<?php

namespace App\Sys\Services\Air;

use App\Http\Resources\AirResource;
use App\Models\AirReservation;
use App\Models\Sessions;
use App\Models\Result;
use App\Models\TestCase;
use App\Sys\Api\TBOAirServices;
use App\Sys\Services;
use Illuminate\Support\Arr;

class AirServices extends Services
{
    private $guest;
    private $resultModel;
    private $tbo;
    private $sessions;

    protected $searchPrepared;

    public function __construct()
    {
        $this->guest = new Sessions();
        $this->tbo = new TBOAirServices();
        $this->resultModel = new Result();
        $this->sessions = new Services\SessionServices();
        $this->searchPrepared = config('Points.Search.prepared_data');
    }

    public function search($data)
    {

        // check guest Result
        $id = request()->attributes->get('guest_id');
        if($this->sessions->checkSessionstime($id))
        {
            $this->searchPrepared;
        }
        $air = $this->resultModel->where([['guest_id', $id], ['type', 'air']])->first();

        // لسه في داتا
        if (!empty($air)) {
            if ($result = $this->getFromResult($data, $id))
                return $result;


            $this->setError($this->errors());
            return false;
        }
        if ($result = $this->getSerachDataTBO($data, $id))
             return $result;


        $this->setError($this->errors());
        return false;

    }

    public function searchDetailsTBO($data)
    {
        //get TokeId and ReuestId
        $id = request()->attributes->get('guest_id');
        $guest = $this->guest->find($id);
        $data->TokenId = $guest->air_token_id;
        $data->TrackingId = $guest->air_tracking_id;
        // result
        $myReuslt = [];
        /*
        if ($data->isLcc == false && $upSell = $this->getUpSell($data))
             $myReuslt['upSell'] = $upSell;
        else
            $myReuslt['upSell'] =[];
        */
        if ($fareRule = $this->fareRule($data))
            $myReuslt['fareRule'] = $fareRule;
        else
            $myReuslt['fareRule'] = $this->errors();


        if ($fareQuote = $this->fareQuote($data))
            $myReuslt['fareQuote'] = $fareQuote;
        else
            $myReuslt['fareQuote'] = $this->errors();


        if ($ssR = $this->getSSR($data))
            $myReuslt['ssR'] = $ssR;
        else
            $myReuslt['ssR'] = [];



        if(isset($myReuslt['fareRule']['errors']) || isset($myReuslt['fareQuote']['errors']))
        {
            $this->setError($myReuslt['fareRule']['errors']??'have errors');
            return  false;
        }
        $case = TestCase::where('guest_id',$id)->first();
        $case->detials_response =json_encode($data);
        $case->detials_result =json_encode($myReuslt);
        $case->save();
        return $myReuslt;

    }

    public function getUpSell($data)
    {
        if ($result = $this->tbo->UpSell($data))
            return $result;


        $this->setError($this->tbo->errors());
        return false;
    }

    public function fareRule($data)
    {
        if ($result = $this->tbo->fareRule($data))
            return $result;


        $this->setError($this->tbo->errors());
        return false;
    }

    public function fareQuote($data)
    {
        if ($result = $this->tbo->fareQuote($data))
            return $result;


        $this->setError($this->tbo->errors());
        return false;
    }

    public function getSSR($data)
    {
        if ($result = $this->tbo->getSSR($data))
            return $result;


        $this->setError($this->tbo->errors());
        return false;
    }

    public function AuthTbo()
    {
        $id = request()->attributes->get('guest_id');
        $guest = $this->guest->find($id);
        if ($guest->air_token_id !== null) {
            return true;
        }

        if ($data = $this->tbo->Auth()) {
            $guest->air_token_id = $data['TokenId'];
            $guest->air_tracking_id = $data['TrackingId'];
            return $guest->save();
        }

        return false;
    }

    private function getSerachDataTBO($data, $id)
    {
        $guest = $this->guest->find($id);
        $data['TokenId'] = $guest->air_token_id;
        if ($search = $this->tbo->search($data)) {
            // Fromat

            $airSearchResults = collect($search['Results'][0])->map(function ($item) {
                return new AirResource($item, 'tbo');
            });
            $ruesl = $this->SaveResult($search, json_decode($airSearchResults), $data, $id);
            $guest->air_tracking_id = $search['TrackingId'];
            $guest->save();

            $count = count($airSearchResults);
            $page = $data['page'];
            $perPage = $data['per_page'];
            $totalPages = ceil($count / $perPage);
            $offset = ($page - 1) * $perPage;
            $returnRueslt['data']= array_slice(json_decode($airSearchResults), $offset, $perPage);
            $returnRueslt['count']=$count;
            return $returnRueslt;
        }
        $this->setError($this->tbo->errors());
        return false;
    }

    public function getFromResult($search, $id)
    {
        // check return data
        $air = $this->resultModel->where([['guest_id', $id], ['type', 'air']])->first();
        $guest = $this->guest->find($id);
        $search['TokenId'] = $guest->air_token_id;
        if (!empty($air)) {
            $oldsearch = json_decode($air->search, true);
            $arr = Arr::except($search, ['page', 'per_page','cases']);
            $a = array_udiff_assoc($oldsearch, $arr, function ($a, $b) {
                return $a <=> $b;
            });
            //$a = array_diff_assoc($oldsearch, $arr);
            if (empty($a)) {
                $airData = json_decode($air->properties);
                $count = count($airData);
                $page = $search['page'];
                $perPage = $search['per_page'];
                $totalPages = ceil($count / $perPage);
                $offset = ($page - 1) * $perPage;
              $rueslt['data'] = array_slice($airData, $offset, $perPage);
              $rueslt['count']=$count;
              return $rueslt;
            }
        }
        // or return search
        if ($result = $this->getSerachDataTBO($search, $id))
            return $result;

        $this->setError($this->errors());
        return false;
    }
    public function SaveResult($searchResult, $flyResult, $data, $id)
    {
        // check to remove
        $air = $this->resultModel->where([['guest_id', $id], ['type', 'air']])->first();
        if (!empty($air)) {
            $air->delete();
        }
        $filteredData = Arr::except($data, ['page', 'per_page']);
        $encodedData = json_encode($filteredData);
        //Save Request
        $addAir = new Result();
        $addAir->properties = json_encode($flyResult);
        $addAir->all_properties = json_encode($searchResult);
        $addAir->guest_id = $id;
        $addAir->search = $encodedData;
        $addAir->is_active = 1;
        $addAir->type = 'air';
        $addAir->save();
        return $addAir;
    }

    public function bookingNoncLcc($data)
    {
        $id = request()->attributes->get('guest_id');
        $guest = $this->guest->find($id);
        $data->TokenId = $guest->air_token_id;
        $data->TrackingId = $guest->air_tracking_id;

        if($ruesalt = $this->tbo->BookingNoncLcc($data))
        {
            return $ruesalt;
            $data['SSRDenied'] =$ruesalt['SSRDenied'];
            $data['SSRMessage'] =$ruesalt['SSRMessage'];
            $data['PNR'] =$ruesalt['PNR'];
            $data['ChangeInItinerary'] =$ruesalt['ChangeInItinerary'];
            $data['TokenId'] =$ruesalt['TokenId'];
            $data['Itinerary'] =$ruesalt['Itinerary'];
            return  $data;
        }
        $this->setError($this->tbo->errors());
        return false;
    }

    public function ticketForLcc($data)
    {
        $id = request()->attributes->get('guest_id');
        $guest = $this->guest->find($id);
        $data->TokenId = $guest->air_token_id;
        $data->TrackingId = $guest->air_tracking_id;

        if($ruesalt = $this->tbo->Ticket($data))
        {
            $resultId = $guest->resultId != null ? $guest->resultId : $data->ResultId;
            $this->SaveTicket($ruesalt,$data,$guest->id,$resultId);
            return $ruesalt;
        }
        $this->setError($this->tbo->errors());
        return false;
    }



    public function getBookingDetalis($data)
    {
        $request['TokenId']=$data['token_id'];
        $request['PNR']=$data['pnr'];

        if($rueslt = $this->tbo->getDitals($request))
            return $rueslt;


        $errors = $this->tbo->errors();
        $this->setError($errors);
        return false;
    }

    public function SaveTicket($ruesalt,$data,$guest_id,$resultId)
    {
        // get Search data
        $searchData = $this->resultModel->where([['guest_id',$guest_id],['type','air']])->first();
        $mySearch = null;
        if(!empty($searchData)){
            $search =json_decode($searchData->properties,true);

            $getSearch = collect($search)->filter(function ($air) use ($resultId) {
                return $air['resultId'] == $resultId;
            });

            $mySearch = $getSearch;
        }

        $ticket = new AirReservation();
        $ticket->guest_id =  $guest_id;
        $ticket->user_id =  Auth()->guard('api')->check() ? Auth()->guard('api')->user()->id:null;
        $ticket->company = $data->company_name;
        $ticket->token_id = $ruesalt['TokenId'] ?? null;
        $ticket->pnr =   $ruesalt['PNR'] ?? null;
        $ticket->is_cll = $ruesalt['Itinerary']['IsLcc'] ?? null;
        $ticket->search = $mySearch != null ? json_encode($mySearch) :null;
        $ticket->response = json_encode($data);
        $ticket->result = json_encode($ruesalt);
        return $ticket->save();
    }
}
