<?php

namespace App\Sys\Repository\staticData\cities;

use App\Models\Cities;
use App\Models\citiesCode;
use App\Models\citiesNamed;
use App\Models\hotel_city;
use Ramsey\Uuid\Type\Integer;

class CitiesRepo
{

    private $city;
    public $HotelCity;
    public function __construct()
    {
        $this->city = new citiesNamed();
        $this->HotelCity = new hotel_city();
    }

    public function gets()
    {
        return $this->city->orderBy('name_ar', 'ASC')->paginate(15);
    }

    public function search($name,$country)
    {
        return $this->city
            ->when($name, function ($q) use ($name) {
            $q->where('name_ar','like' ,"%$name%")
                ->orWhere('name_en','like' ,"%$name%");
        })->where('country_id',$country)->orderBy('updated_at', 'desc')
            ->paginate(20);
    }

    public function searchForApi($name,$country)
    {
        return $this->city
            ->when($name, function ($q) use ($name) {
                $q->where('name_ar','like' ,"%$name%")
                    ->orWhere('name_en','like' ,"%$name%");
            })->where('country_id',$country)->orderBy('updated_at', 'desc')
            ->get();
    }

    public function add($data)
    {
        $idsArray = array_map('intval', explode(',', $data['ids']));
        $this->city->country_id = $data['country_id'];
        $this->city->name_ar = $data['name_ar'];
        $this->city->name_en = $data['name_en'];
        if ($this->city->save()) {
            foreach ($idsArray as $id) {
                $re = $this->HotelCity->find($id);
                if (!empty($re)) {
                    // هنا نجيب ال id
                    $x = new citiesCode();
                    $x->company = $re->company;
                    $x->city_id = $this->city->id;
                    $x->country_id = $this->city->country_id;
                    $x->code = $re->code;
                    $x->name = $re->name;
                    $x->is_active = 1;
                    $x->save();
                    $re->status = 1;
                    $re->save();
                }
            }
        }
        return true;
    }

    public function updated($data)
    {
        $idsArray = array_map('intval', explode(',', $data['ids']));
        $city = $this->city->find($data['city_id']);
        if(!empty($city))
        {
            foreach ($idsArray as $id) {
                $re = $this->HotelCity->find($id);
                if (!empty($re)) {
                    $x = new citiesCode();
                    $x->company = $re->company;
                    $x->city_id = $data['city_id'];
                    $x->country_id = $city->country_id;
                    $x->code = $re->code;
                    $x->is_active = 1;
                    $x->save();
                    $re->status = 1;
                    $re->save();
                }
            }

            return true;
        }

        return false;

    }

    public function getCitiesNamed($id)
    {
        return $this->city->where('country_id', $id)->orderBy('name_ar', 'ASC')->get();
    }

    public function withCode($id)
    {
        return $this->city->with('code')->find($id);
    }
}
