<?php

namespace App\Sys\Repository;

use App\Models\searchResult;
use App\Models\SessionFirst;
use App\Models\Sessions;
use App\Models\SessionsToken;
use Carbon\Carbon;

class SessionsRepo
{

    private $session;
    private $sessionToken;
    private $sessionFirst;

    public function __construct()
    {
        $this->session = new Sessions();
        $this->sessionToken = new SessionsToken();
        $this->sessionFirst = new SessionFirst();
    }
    public function add($data)
    {
        //$this->session->token = $token;
        $this->session->client_id =Auth()->guard('api')->check() ? Auth()->guard('api')->user()->id :null;
        $this->session->re_time = Carbon::now();
        $this->session->exp_time = $data['exp'];
        $this->session->search = json_encode($data['search']);
        $this->session->ip_address = request()->getClientIp();
        if($this->session->save())
            return $this->session->id;

        return false;
    }

    public function updatedStatus($data)
    {
        $session = $this->session->find($data['id']);
        $session->status = $data['status'];
        return $session->save();
    }

    public function updatedSearch($id)
    {
        $usession = $this->session->find($id);
        $usession->search_result = 1;
        return $usession->save();
    }
    public function updatedToken($data)
    {
        $session = $this->session->where([
            ['token', $data['oldToken']],
            ['status',0]
        ])->first();

        $session->token = $data['token'];
        $session->client_id =Auth()->guard('api')->check() ? Auth()->guard('api')->user()->id :null;
        $session->save();
        return $session;
    }

    public function closeAnySessionByToken($token)
    {
        $this->session->where('token', $token) ->update([
            'status' => 1,
        ]);
        return true;
    }

    public function checkTime($token)
    {
        return  $this->session->where([
            ['token', $token],
            ['status',0]
        ])->orderBy('id','desc')->first();

    }

    public function getSessionByToken($token)
    {
      return  $this->session->where([
            ['token', $token],
            ['status',0]
        ])->orderBy('id','desc')->first();
    }

    public function getSessionById($id)
    {
        return $this->session->find($id);
    }

    public function addSessionFirstTable($data)
    {

        $add = new SessionFirst();
        $add->session_id = $data['session_id'];
        $add->company = $data['company'];
        $add->result = json_encode($data['data']);
        $add->status = $data['status'];
        $add->complete = 0;
        return$add->save();


    }

    public function AddSessionToken($data)
    {
        $this->sessionToken->session_id = $data['session_id'];
        $this->sessionToken->company = $data['company'];
        $this->sessionToken->key = $data['key'];
        $this->sessionToken->value = $data['value'];
        $this->sessionToken->expired_date = $data['expired_date'];
        return $this->sessionToken->save();
    }

    public function getSessionFirstData($session)
    {

        return $this->sessionFirst->where([
            ['session_id',$session],
            ['status',1]
        ])->get();

    }

    public function NotWell($session)
    {
        return $this->sessionFirst->where('session_id',$session)->get();
    }

    public function getTokenBySessionID($sessionID,$key,$company)
    {
        return $this->sessionToken->where([
            ['session_id',$sessionID],
            ['key',$key],
            ['company',$company]])
            ->where('key',$key)->first();
    }
}
