<?php

namespace App\sys\Api;

use App\Http\Resources\HotelResource;
use App\Http\Resources\RoomsResource;
use App\Http\Resources\TBOPreBookResources;
use App\Models\TestCase;
use App\Sys\Services;
use App\Sys\ServicesProvidor\TBO\TBO;

class TBOServices extends Services
{
    use TBO;

    public function getCountry()
    {
        $country = $this->TBO('get', 'CountryList', null, 'hotel');
        return $country['CountryList'];
    }

    public function getCity($code)
    {
        $city = $this->TBO('post', 'Citylist', ['CountryCode' => $code], 'hotel');
        return $city['CityList'] ?? [];
    }

    public function HotelByCity($code, $is_detailed, $layout)
    {
        $pramter = [
            'CityCode' => $code,
            'IsDetailedResponse' => $is_detailed
        ];
        $hotel = $this->TBO('post', 'TBOHotelCodeList', $pramter, 'hotel');
        if ($layout == "array") {
            if ($hotel['Status']['Code'] == 200)
                return collect($hotel['Hotels'])->pluck('HotelCode')->toArray();
            else
                return [];
        }

        return $hotel['Hotels'];
    }

    public function searchRooms($data)
    {
        $rooms = $this->TBO('POST', 'Search', $data, 'hotel');
        $id = request()->attributes->get('guest_id');
        $case = TestCase::where('guest_id', $id)->first();
        if (empty($case)){
            $new = new TestCase();
            $new->guest_id = $id;
            $new->name = 'test case' . isset($data['cases']) ? $data['cases'] : $id;
            $new->cases = isset($data['cases']) ? $data['cases'] : $id;
            $new->type = 'hotel';
            $case->room_response = json_encode($data);
            $case->room_result = json_encode($rooms);
            $new->save();
        }else{
        $case->room_response = json_encode($data);
        $case->room_result = json_encode($rooms);
        $case->save();
          }
        if ($rooms['Status']['Code'] == 200) {
            $hotel = $rooms['HotelResult'][0]['HotelCode'];
            $curr = $rooms['HotelResult'][0]['Currency'];
            $hotelSearchResults = collect($rooms['HotelResult'][0]['Rooms'])->map(function ($item) use ($hotel, $curr) {
                return new RoomsResource($item, 'tbo', $hotel, $curr);
            });
            return $hotelSearchResults;
        }


        $this->setError($rooms['Status']['Description']);
        return false;
    }

    public function searchHotel($data)
    {
        $hotel_code = $this->HotelByCity(request()->city, false, 'array');
        if ($hotel_code == null) {
            $this->setError(['There are no hotels in this city']);
            return false;
        }

        $limited_hotel_code = array_slice($hotel_code, 0, 100);
        $code = implode(',', $limited_hotel_code);

        $data["HotelCodes"] = $code;
        $hotel = $this->TBO('POST', 'HotelSearch', $data, 'hotel');
        $id = request()->attributes->get('guest_id');
        $case = TestCase::where('guest_id', $id)->first();
        if (empty($case)) {
            $new = new TestCase();
            $new->guest_id = $id;
            $new->name = 'test case' . isset($data['cases']) ? $data['cases'] : $id;
            $new->cases = isset($data['cases']) ? $data['cases'] : $id;
            $new->type = 'hotel';
            $new->search_response = json_encode($data);
            $new->search_result = json_encode($hotel);
            $new->save();
        } else {
            $case->name = 'test case' . $data['cases'];
            $case->cases = $data['cases'];
            $case->search_response = json_encode($data);
            $case->search_result = json_encode($hotel);
            $case->save();
        }
        if ($hotel['Status']['Code'] == 200) {
            $hotelSearchResults = collect($hotel['HotelSearchResults'])->map(function ($item) {
                return new HotelResource($item, 'tob');
            });

            return $hotelSearchResults;
        }


        $errors['code'] = $hotel['Status']['Code'];
        $errors['Description'] = $hotel['Status']['Description'];
        $this->setError($errors);
        return false;

    }

    public function prebook($data)
    {
        $hotel = $this->TBO('post', 'PreBook', $data, 'hotel');
        $id = request()->attributes->get('guest_id');
        $case = TestCase::where('guest_id', $id)->first();
        $case->prebook_response = json_encode($data);
        $case->prebook_result = json_encode($hotel);
        $case->save();
        if ($hotel['Status']['Code'] == 200) {
            $hotelSearchResults = collect($hotel['HotelResult'])->map(function ($item) {
                return new TBOPreBookResources($item, 'tbo');
            });
            return $hotelSearchResults;
        }
        $errors['code'] = $hotel['Status']['Code'];
        $errors['Description'] = $hotel['Status']['Description'];
        $this->setError($errors);
        return false;


    }

    public function bookingDetails($data)
    {
        $hotel = $this->TBO('post', 'BookingDetail', $data, 'hotel');
        /*
        $id = request()->attributes->get('guest_id');
        $case = TestCase::where('guest_id', $id)->first();
        $case->gobooking_response = json_encode($data);
        $case->gobooking_result = json_encode($hotel);
        $case->save();
        */
        if ($hotel['Status']['Code'] == 200) {
            return $hotel;
        }
        $this->setError($hotel);
        return false;
    }

    public function booking($data)
    {

        $send = json_decode($data, true);
        $unwantedKeys = ['rome_name', 'hotel_name', 'check_in', 'check_out','room_name'];
        foreach ($unwantedKeys as $key) {
            if (isset($send[$key])) {
                unset($send[$key]);
            }
        }
        $send = json_encode($send);

        $hotel = $this->TBO('post', 'Book', $send, 'hotel');
        $id = request()->attributes->get('guest_id');
        $case = TestCase::where('guest_id', $id)->first();
        $case->booking_response = json_encode($data);
        $case->booking_result = json_encode($hotel);
        $case->done = 1;
        $case->save();
        if ($hotel['Status']['Code'] == 200) {
            $this->setData($hotel);
            return true;
        }
        $this->setError($hotel);
        return false;
    }

    public function cancel($data)
    {
        $hotel = $this->TBO('post', 'Cancel', $data, 'hotel');
        /*
        $id = request()->attributes->get('guest_id');
        $case = TestCase::where('guest_id', $id)->first();
        $case->cansel_response = json_encode($data);
        $case->cansel_result = json_encode($hotel);
        $case->save();
        */
        if ($hotel['Status']['Code'] == 200) {
            $this->setData($hotel);
            return true;
        }
        $this->setError($hotel);
        return false;
    }

    public function hotelDetials($data)
    {
        $hotel = $this->TBO('post', 'HotelDetails', $data, 'hotel');
        if ($hotel['Status']['Code'] == 200)
            return $hotel['HotelDetails'];


        $this->setError($hotel);
        return false;
    }
}
