<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class RoomsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    protected $companyName;
    protected $hotelCode;
    protected $currency;
    public function __construct($resource, $companyName,$hotelCode,$currency)
    {
        parent::__construct($resource);
        $this->companyName = $companyName;
        $this->hotelCode = $hotelCode;
        $this->currency = $currency;
    }
    public function toArray(Request $request): array
    {
        return [
            'company_name' => $this->companyName,
            'hotel_code' =>  $this->hotelCode,
            'currency' => $this->currency,
            'name_room' => $this['Name'],
            'bookingCode' => $this['BookingCode'],
            'inclusion' => $this['Inclusion'],
            'dayRates' => $this['DayRates'],
            'totalFare' => $this['TotalFare'],
            'totalTax' => $this['TotalTax'],
            'cancelPolicies' => $this['CancelPolicies'],
            'mealType' => $this['MealType'],
            'required_fields'=>[
                'company'=>$this->companyName,
                'bookingCode' => $this['BookingCode'],
                'payment'=>'Limit'
            ],
            'isRefundable' => $this['IsRefundable'],
            'withTransfers' => $this['WithTransfers'],
            'all_data'=> $this->resource
        ];
    }
}
