<?php

namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class AirResource extends JsonResource
{

    protected $companyName;

    public function __construct($resource, $companyName)
    {
        parent::__construct($resource);
        $this->companyName = $companyName;
    }

    public function toArray($request)
    {
        $flight = $this->getSegments($this['Segments']);
        return [
            'company_name' => $this->companyName,
            'resultId'=>$this['ResultId'],
            'origin'=>$this['Origin'],
            'destination'=>$this['Destination'],
            'segments'=>$this['Segments'],
            'flight'=>$flight['flight'],
            'details'=>$flight['details'],
            'totalFare'=>$this['Fare']['TotalFare'],
            'currency'=>$this['Fare']['AgentPreferredCurrency'],
            'isLcc'=>$this['IsLcc'],
            'nonRefundable'=>$this['NonRefundable'],
            'airlineRemark'=>$this['AirlineRemark'],
            'fare'=>$this['Fare'],
            'fareBreakdown'=>$this['FareBreakdown'],
            'all_data'=> $this->resource
        ];
    }

    function parseDuration($duration) {
        $parts = explode(':', $duration);
        return ($parts[0] * 60) + $parts[1] + ($parts[2] / 60);
    }

    function formatDuration($totalMinutes) {
        $hours = floor($totalMinutes / 60);
        $minutes = $totalMinutes % 60;
        $hoursText = $hours == 1 ? "$hours hr" : "$hours hrs";
        $minutesText = $minutes == 1 ? "$minutes min" : "$minutes mins";

        if ($hours > 0 && $minutes > 0) {
            return "$hoursText $minutesText";
        } elseif ($hours > 0) {
            return $hoursText;
        } else {
            return $minutesText;
        }
    }

    function getSegments($segments)
    {
        $flightDuration= [];
        $flightDetials =[];
        $first =0;
        foreach ($segments as $segmentGroup) {
                $totalMinutes = 0;
                $airLineName = [];
                $airCode = [];
                $capenClass =[];
                $cabinBaggage =[];
                $includedBaggage =[];
                $cityName='';
                $destinationCityName='';
                $originAirName='';
                $destinationAirName='';
                $named = $first == 0 ?'outboundFlight':'inboundFlight';
                /*
            "IncludedBaggage": "0 KG",
                            "CabinBaggage": "7 KG",
                */
                foreach ($segmentGroup as $index =>$segment) {
                    $timeDuration =0;
                    if ($index === 0) {
                        $origin = $segment['Origin']['AirportCode'];
                        $depart = $segment['DepartureTime'];
                        $cityName = $segment['Origin']['CityName'];
                        $originAirName = $segment['Origin']['AirportName'];
                    }
                    $airLineName []=$segment['AirlineDetails']['AirlineName'];
                    $cabinBaggage[]=$segment['CabinBaggage'] ?? '';
                    $includedBaggage[]=$segment['IncludedBaggage'] ?? '';
                    $key=$segment['AirlineDetails']['AirlineCode'] . '-'.$segment['AirlineDetails']['FlightNumber'];
                    if(!isset($airCode[$key]))
                    {
                        $airCode[$key] =[
                            'AirlineCode'=>$segment['AirlineDetails']['AirlineCode'],
                            'FlightNumber'=>$segment['AirlineDetails']['FlightNumber']
                        ];
                    }
                    $totalMinutes += $this->parseDuration($segment['Duration']);
                    $totalMinutes += $this->parseDuration($segment['GroundTime']);
                    $timeDuration += $this->parseDuration($segment['Duration']);
                    $timeDuration += $this->parseDuration($segment['GroundTime']);

                    if ($index === count($segmentGroup) - 1) {
                        $destination = $segment['Destination']['AirportCode'];
                        $destinationCityName = $segment['Destination']['CityName'];
                        $arrival = $segment['ArrivalTime'];
                        $destinationAirName = $segment['Destination']['AirportName'];
                    }
                    $groundtime = $this->parseDuration($segment['GroundTime']);
                    $flightDetials[$named][]=[
                        'name'=>$segment['AirlineDetails']['AirlineName'],
                        'code'=>$segment['AirlineDetails']['AirlineCode'],
                        'craft'=>$segment['Craft'],
                        'groundTime'=>$this->formatDuration($groundtime),
                        'departure'=>[
                            'cityName'=>$segment['Origin']['CityName'],
                            'cityCode'=>$segment['Origin']['CityCode'],
                            'country'=>$segment['Origin']['CountryName'],
                            'countryCode'=>$segment['Origin']['CountryCode'],
                            'airportName'=>$segment['Origin']['AirportName'],
                            'airportCode'=>$segment['Origin']['AirportCode'],
                            'terminal'=>$segment['Origin']['Terminal'],
                            'DepartureTime'=>  \Carbon\Carbon::parse($segment['ArrivalTime'])->format('Y-m-d H:i:s'),
                            'DepartureTime_timestamp'=>  \Carbon\Carbon::parse($segment['ArrivalTime'])->timestamp,
                        ],
                        'arrival'=>[
                            'cityName'=>$segment['Destination']['CityName'],
                            'cityCode'=>$segment['Destination']['CityCode'],
                            'country'=>$segment['Destination']['CountryName'],
                            'countryCode'=>$segment['Destination']['CountryCode'],
                            'airportName'=>$segment['Destination']['AirportName'],
                            'airportCode'=>$segment['Destination']['AirportCode'],
                            'terminal'=>$segment['Destination']['Terminal'],
                            'arrivalTime'=> \Carbon\Carbon::parse($segment['DepartureTime'])->format('Y-m-d H:i:s'),
                           'arrivalTime_timestamp'=> \Carbon\Carbon::parse($segment['DepartureTime'])->timestamp,
                        ],
                        'flightDuration'=>$this->formatDuration($timeDuration),
                        'baggage'=>[
                            'cabin'=>$segment['IncludedBaggage']?? '' ,
                            'checkIn'=>$segment['CabinBaggage'] ?? ''
                        ],

                    ];

                    if($segment['CabinClass']!=null && $segment['CabinClass']!= "")
                        $capenClass[]=$segment['CabinClass'];
                }

                $flightDuration['flight'][] = [
                   'origin'=> $origin,
                    'originAirName'=>$originAirName,
                    'destinationAirName'=>$destinationAirName,
                    'time'=>$this->formatDuration($totalMinutes),
                    'destination'=> $destination,
                    'cityNameOrigin'=>$cityName,
                    'cityNameDestination'=>$destinationCityName,
                    'arrival_timestamp'=> \Carbon\Carbon::parse($arrival)->timestamp,
                    'arrival'=> \Carbon\Carbon::parse($arrival)->format('Y-m-d H:i:s'),
                    'depart_timestamp'=> \Carbon\Carbon::parse($depart)->timestamp,
                    'depart'=> \Carbon\Carbon::parse($depart)->format('Y-m-d H:i:s'),
                    'airlineName'=> array_unique($airLineName),
                    'airlineCode'=> array_values($airCode),
                    'cabinClass'=> array_unique($capenClass),
                    'cabinBaggage'=> array_unique($cabinBaggage),
                    'includedBaggage'=> array_unique($includedBaggage)
                ];
                $flightDuration['details']= $flightDetials;
                $first +=1;
                //$flightDuration

        }

        return $flightDuration;
    }

}

