<?php

namespace App\Http\Middleware;

use App\Models\Sessions;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Closure;

class checkGuest
{
    public function handle(Request $request, Closure $next)
    {
        $old = $request->hasHeader('guest') ? $request->header('guest') : null;
        $guest = $request->hasHeader('Authorization') ? $request->header('Authorization') : null;
        if(Auth()->guard('api')->check()){
            // check Guest
            $check = Sessions::where([
                ['token',$guest]])->first();
            if(!empty($check))
            {
                $request->attributes->set('guest_token', $guest);
                $request->attributes->set('guest_id', $check->id);
                return $next($request);
            }
            $guest = new Sessions();
            $guest->token =$guest;
            $guest->client_id  =Auth()->guard('api')->user()->id;
            $guest->exp_time  =Carbon::now()->addDays(360);
            $guest->save();
        }

        $check = Sessions::where([
            ['token',$old],['exp_time','>=',Carbon::now()]])->first();
        if(!empty($check))
        {
            $request->attributes->set('guest_token', $guest);
            $request->attributes->set('guest_id', $check->id);
            return $next($request);
        }
        return response(['status'=>403,'massage'=>'not authorized'], 403);
    }
}
