<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
class LogRequests
{
    public function handle(Request $request, Closure $next)
    {
        $logData = [
            'method' => $request->getMethod(),
            'url' => $request->fullUrl(),
            'headers' => $request->headers->all(),
            'body' => $request->all()
        ];

        // Log to the custom request channel
        Log::channel('request')->info('Request Logged:', $logData);

        // Log to the default log channel
        Log::info('Request Logged:', $logData);

        return $next($request);
    }
}
