<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Models\Countries;
use App\Models\hotel_city;
use App\sys\Api\TBOServices;
use App\Sys\ServicesProvidor\MR\MR;
use Illuminate\Support\Facades\DB;

class StaticData extends Controller
{

    use MR;

    public function index()
    {


        $egy = Countries::where('id', '>', 29)->get();
        $x = new TBOServices();
        foreach ($egy as $e) {
            $city = $x->getCity($e->code);
            foreach ($city as $c) {
                $a = new hotel_city();
                $a->company = 'tbo';
                $a->name = $c['Name'];
                $a->code = $c['Code'];
                $a->country_id = $e->id;
                $a->save();
            }
        }

        return 'done';
        /*
        foreach ($city as $c)
        {
            $a = new hotel_city();
            $a->company = 'tbo';
            $a->name = $c['Name'];
            $a->code = $c['Code'];
            $a->country_id = 29;
            $a->save();
        }
*/
        /*
        foreach ($egy as $key) {
            foreach ($city as $c) {
                similar_text($key, $c['Name'], $percent);
                if ($percent > 70) {
                    $in[$key] = $c['Name'];
                }
            }
            if(!in_array($key,$in))
                $out[] = $key;
        }
        */
    }

    public function indexMR()
    {
        $getToken =  $this->MR('GET',null,'gettoken',null);

        $token = $getToken['accessToken'];
        /*
            $egy = Countries::find(16);
            $point = 'staticdata/cities' . '/' . $egy->code;
            $get =  $this->MR('GET', $token, $point, ['items' => 50000, 'page' => 1]);
            return $city = $get['data']['cities'];
        */
        $egy = Countries::where('id','>',31)->get();

        foreach ($egy as $e) {
            $point = 'staticdata/cities' . '/' . $e->code;
            $get =  $this->MR('GET', $token, $point, ['items' => 50000, 'page' => 1]);
            $city = $get['data']['cities'];
            foreach ($city as $c) {
                $a = new hotel_city();
                $a->company = 'mr';
                $a->name = $c['name'];
                $a->code = $c['code'];
                $a->country_id = $e->id;
                $a->latitude = $c['geocode']['latitude'];
                $a->longitude = $c['geocode']['longitude'];
                $a->save();
            }

        }

        return 'done';
    }

    public function check()
    {

        $results = DB::table('hotel_city')
            ->select('code', DB::raw('GROUP_CONCAT(name) as names'), DB::raw('COUNT(*) as occurrences'))
            ->groupBy('code')
            ->having('occurrences', '>', 1)
            ->get();

        $formattedResults = $results->map(function($item) {
            return [
                'code' => $item->code,
                'names' => explode(',', $item->names),
                'occurrences' => $item->occurrences
            ];
        });

        return $formattedResults;
        $data = hotel_city::where('country_id',16)->get()->groupBy('company');
        $tbo = $data['tbo'];
        $mr = $data['mr'];
        $cities1 = count($tbo) > count($mr) ? $tbo : $mr;
        $cities2 = count($tbo) < count($mr) ? $tbo : $mr;
        $same = [];
        $citiesOne = [];
        $citiesTwo = [];

        foreach ($cities2 as $c) {
            foreach ($cities1 as $i)
            {
                similar_text($c['name'], $i['name'], $percent);
                if($percent > 70)
                {
                    $same[$c['name']][$c['company']]=$c;
                    $same[$c['name']][$i['company']]=$i;
                    $citiesOne[]=$i['name'];
                    $citiesTwo[]=$c['name'];
                }
            }
        }
        dd($same, $citiesOne, $citiesTwo);

    }



}
