<?php

namespace App\Http\Controllers\api;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Models\Hotel;
use App\sys\Services\Hotel\HotelServices;
use App\Sys\ServicesProvidor\TBO\TBO;
use GuzzleHttp\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Validator;

class HotelController extends Controller
{
    use ApiResponse;
    use TBO;

    private $hotel;

    public function __construct()
    {
        $this->hotel = new HotelServices();
    }

    public function getCountry()
    {
        $country = $this->hotel->getCountry();
        return $this->apiResponse(200, 'Country data', null, $country);
    }

    public function getCity($code)
    {
        $city = $this->hotel->city($code);
        return $this->apiResponse(200, 'Country data', null, $city);
    }

    public function HotelByCity($code, $is_detailed = false)
    {
        $isDe = $is_detailed == false ? 'out DetailedResponse' : "DetailedResponse";
        $massage = 'hotel data with ' . $isDe;
        $hotel = $this->hotel->getHotelCodeByCity($code, $is_detailed, 'normal');
        return $this->apiResponse(200, $massage, null, $hotel);
    }

    public function search()
    {


        //return request()->all();
        $chiled = request()->children_ages != null ? array_map('intval', explode(',', request()->children_ages)):[];
        $Adults = request()->adults != null ? array_map('intval', explode(',', request()->adults)):[];
        $Children = request()->children != null ? array_map('intval', explode(',', request()->children)):[];

        $PaxRooms = [];

        $ageIndex = 0;

        for ($i = 0; $i < count($Adults); $i++) {
            $numChildren =  isset($Children[$i])?(int)$Children[$i]:0;
            $room = [
                "Adults" =>(int) $Adults[$i],
                "Children" => $numChildren,
                "ChildrenAges" => array_slice($chiled, $ageIndex, $numChildren)
            ];

            $ageIndex += $numChildren;

            $PaxRooms[] = $room;
        }


        //return request()->all();
        /*
          $paxRooms = [
              [
                  'Adults' => (int)request()->adults,
                  'Children' => (int)request()->children,
                  'ChildrenAges' =>$chiled
              ]
          ];*/
        $filter = [
            'Refundable' => (string)request()->refundable,
            'NoOfRooms' => request()->nom_room,
            'MealType' => (string)request()->meal_type,

        ];
        $pramter = [
            "CheckIn" => request()->check_in,
            "CheckOut" => request()->check_out,
            "GuestNationality" => request()->guestNationality,
            "PaxRooms" => $PaxRooms,
            "Filters" => $filter,
            "IsDetailedResponse" => true,
            "ResponseTime" => 23.0,
            "Currency"=> request()->has('Currency') ?  request()->Currency : "USD",
            "MinPrice"=> 0,
            "MaxPrice"=> 30,
            "cases"=> request()->has('cases') ? request()->cases : request()->attributes->get('guest_id')

        ];

        if (request()->has('hotel') && request()->hotel != null) {
            //get room
            $pramter["HotelCodes"] = request()->hotel;
            if ($rooms = $this->hotel->SearchRoom($pramter))
                return $this->apiResponse(200, 'data rooms', null, $rooms);


            $errors = $this->hotel->errors();
            return $this->apiResponse(201, 'data Hotel', $errors, null);
        } else {
            if ($hotel = $this->hotel->SearchHotel($pramter))
                return $this->apiResponse(200, 'data Hotel', null, $hotel);


            $errors = $this->hotel->errors();
            return $this->apiResponse(201, 'data Hotel', $errors, null);
        }
    }


    public function prebook(Request $request)
    {
        $pramter = [
            'BookingCode' => $request->get('booking_code'),
            'PaymentMode' => $request->get('payment'),
        ];

        if ($hotel = $this->hotel->getPerBook($pramter, $request->company_name))
            return $this->apiResponse(200, 'data Rooms', null, $hotel);


        $errors = $this->hotel->errors();
        return $this->apiResponse(201, 'data Rooms', $errors['Description'], null);

    }

    public function bookingBTO(Request $request)
    {
        $jsonContent = $request->getContent();

        if (empty($jsonContent))
            return $this->apiResponse(400, 'Bad Request', 'JSON content is empty', null);


        $updatedJsonData = json_decode($jsonContent);
        $updatedJsonData->ClientReferenceId = uniqid() . time() . Str::random(5);
        $updatedJsonData->BookingReferenceId = uniqid() . time() . Str::random(6);
        if ($this->hotel->tboBooking($updatedJsonData)) {
            $data = $this->hotel->getData();
            $send = [
                'client_referenceId' => $data['ClientReferenceId'],
                'confirmation_number' => $data['ConfirmationNumber']
            ];
            return $this->apiResponse(200, $data['Status']['Description'], null, $send);
        }
        $errors = $this->hotel->errors();
        return $this->apiResponse(201, 'Errors', $errors['Status']['Description'], null);

    }

    public function bookingDetail(Request $request)
    {
        $req = Validator::make($request->all(), [
            'company' => 'required',
           // 'booking_referenceId' => 'required_if:confirmation_number,!=,null',
            'confirmation_number' => 'required',
        ]);
        if ($req->fails()) {
            return $this->apiResponse(201, 'ValidatorErrors', $req->errors());
        }

        if($hotel = $this->hotel->bookingDetails($request->confirmation_number,$request->company))
        {
            return $this->apiResponse(200, $hotel['Status']['Description'], null, $hotel['BookingDetail']);
        }

        $errors = $this->hotel->errors();
        return $this->apiResponse(201, 'Errors', $errors['Status']['Description'], null);

    }

    public function cancel(Request $request)
    {

        $req = Validator::make($request->all(), [
            'confirmation_number' => 'required',
        ]);
        if ($req->fails()) {
            return $this->apiResponse(201, 'ValidatorErrors', $req->errors());
        }
        $data['ConfirmationNumber'] = $request->confirmation_number;
        if ($this->hotel->cancel($data, 'tbo')) {
            $resl = $this->hotel->getData();
            return $this->apiResponse(200, $resl['Status']['Description'], null, $resl['ConfirmationNumber']);
        }
        $errors = $this->hotel->errors();
        return $this->apiResponse(201, 'Errors', $errors['Status']['Description'], null);
    }

    public function hotelDetails(Request $request)
    {

        $req = Validator::make($request->all(), [
            'Hotelcodes' => 'required',
        ]);
        if ($req->fails()) {
            return $this->apiResponse(201, 'ValidatorErrors', $req->errors());
        }
        if($hotel = $this->hotel->getHotelDetails($request->all()))
            return $this->apiResponse(200, 'data Hotel', null, $hotel);


        $errors = $this->hotel->errors();
        return $this->apiResponse(201, 'Errors', $errors['Description'], null);
    }

    public function test()
    {
        $client = new Client();
        $response = $client->get('TBO_STAGING_API_SERVICE_URL', [
            'auth' => [env('TBO_STAGING_API_USERNAME'), env('TBO_STAGING_API_PASSWORD')],
            'query' => ['cityName' => 'cairo'],
        ]);

        $cityData = json_decode($response->getBody(), true);
        // Extract city code from the response
        $cityCode = $cityData['CityList'][0]['CityCode'] ?? null;

        return $cityCode;
    }
}
