<?php

namespace App\Http\Controllers\api;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\CountryCollection;
use App\Sys\Services\staticData\cities\CitiesNamedServices;
use App\Sys\Services\staticData\country\CountryServices;

class BasicDataController extends Controller
{
    use ApiResponse;
    private $country;
    private $city;


    public function __construct()
    {
        $this->country = new CountryServices();
        $this->city = new CitiesNamedServices();
    }

    public function getCountry($name)
    {
        $country = $this->country->search($name);
        $coll = new CountryCollection($country);
        return $this->apiResponse(200,'country data',null,$coll);
    }

    public function cities($country_id,$name = null)
    {
        $cities = $this->city->searchForApi($name,$country_id);
        $coll = new CountryCollection($cities);
        return $this->apiResponse(200,'country data',null,$coll);
    }


}
