<?php

namespace App\Http\Controllers\api\Air;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\AirPortsCollection;
use App\Sys\Services\Air\AirPortsServices;

class DataSenderController extends Controller
{
    use ApiResponse;
    private $airports;

    public function __construct()
    {
        $this->airports = new AirPortsServices();
    }

    public function search($code)
    {
        $airports = $this->airports->search($code);
        $collect = new AirPortsCollection($airports);
        return $this->apiResponse(200,'airports data',null,$collect);
    }
}
