<?php

namespace App\Http\Controllers\api\Air;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Sys\Services\Air\AirServices;
use App\Sys\Services\test;
use Illuminate\Http\Request;
use Validator;
class AirControllers extends Controller
{
    use ApiResponse;

    public $airSer;

    public function __construct()
    {
        $this->airSer = new AirServices();
    }
    public function search(Request $request)
    {
        $jsonContent = $request->getContent();
        $updatedJsonData = json_decode($jsonContent);
        if (empty($updatedJsonData))
            return $this->apiResponse(400, 'Bad Request', ['json'=>'JSON content is empty'], null);


        $ru = (array)$updatedJsonData;
        if (isset($ru['Segment']) && is_array($ru['Segment'])) {
            $ru['Segment'] = array_map(function ($ru) {
                return (array)$ru;
            }, $ru['Segment']);
        }
        if ($data = $this->airSer->search($ru))
            return $this->apiResponse(200, 'Search Success', null, $data);


        $errors = $this->airSer->errors();
        if(empty($errors))
            return $this->apiResponse(200, 'Search Success', null, []);


        return $this->apiResponse(201, 'error', $errors, null);
    }
    public function searchDetials(Request $request)
    {

        $jsonContent = $request->getContent();
        $updatedJsonData = json_decode($jsonContent);
        if (empty($updatedJsonData))
            return $this->apiResponse(201, 'Bad Request', ['json'=>'JSON content is empty'], null);


        if ($updatedJsonData->company_name == "tbo") {
            if ($data = $this->airSer->searchDetailsTBO($updatedJsonData))
                return $this->apiResponse(200, 'search detials Success', null, $data);

            $errors = $this->airSer->errors();
            return $this->apiResponse(201, 'error', $errors, null);
        }

        return $this->apiResponse(201, 'error', ['company_name'=>'Not Found Company'], null);
    }
    public function booking(Request $request)
    {
        $jsonContent = $request->getContent();
        $updatedJsonData = json_decode($jsonContent);
        if (empty($updatedJsonData))
            return $this->apiResponse(400, 'Bad Request', 'JSON content is empty', null);


        if ($updatedJsonData->company_name == "tbo") {

            if($updatedJsonData->Itinerary->IsLcc == false){

                if($data = $this->airSer->bookingNoncLcc($updatedJsonData))
                    return $this->apiResponse(200, 'Search Success', null, $data);


                $errors = $this->airSer->errors();
                return $this->apiResponse(201, 'error', $errors, null);
            }
            return $this->apiResponse(201, 'error', 'Go To Ticket', null);
        }
    }
    public function ticketLcc(Request $request)
    {
        $jsonContent = $request->getContent();
        $updatedJsonData = json_decode($jsonContent);
        if (empty($updatedJsonData))
            return $this->apiResponse(400, 'Bad Request', 'JSON content is empty', null);

        if ($updatedJsonData->company_name == "tbo") {
            if($updatedJsonData->Itinerary->IsLcc == false && $updatedJsonData->PNR == null){
                return $this->apiResponse(201, 'error', ['PNR'=>'is required value , if not have PNR Got to Booking first'], null);
            }

            if($data = $this->airSer->ticketForLcc($updatedJsonData))
                return $this->apiResponse(200, 'Search Success', null, $data);


            $errors = $this->airSer->errors();
            return $this->apiResponse(201, 'error', $errors, null);
        }

        return $this->apiResponse(201, 'error', ['company_name'=>'is required  and value is true'], null);


    }
    public function GetBookingDetails(Request $request)
    {

        $req = Validator::make($request->all(), [
            'pnr' => 'required',
            'token_id' => 'required',
            'company_name' => 'required',
        ]);
        if ($req->fails()) {
            return $this->apiResponse(201, 'ValidatorErrors', $req->errors());
        }

        if($request->company_name == "tbo"){
            if($data = $this->airSer->getBookingDetalis($request->all())){
                return $this->apiResponse(200, 'GEt Booking Detalis', null, $data);
            }

            $errors = $this->airSer->errors();
            return $this->apiResponse(201, 'error', $errors, null);
        }

        $this->airSer->setError(['company_name'=>"not tbo"]);
        $errors = $this->airSer->errors();
        return $this->apiResponse(201, 'error', $errors, null);

    }

    public function test()
    {
        $x =  new test();
        return $x->search(['data']);
    }
}


