<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Sys\Services\staticData\cities\CitiesComanyServices;
use App\Sys\Services\staticData\cities\CitiesNamedServices;
use App\Sys\Services\staticData\country\CountryServices;
use App\Sys\Services\SupplierServices;
use Illuminate\Http\Request;

class citiesControllers extends Controller
{
    private $country;
    private $comanyCities;
    private $cities;
    private $supplier;
    public function __construct()
    {
        $this->country = new CountryServices();
        $this->comanyCities = new CitiesComanyServices();
        $this->cities = new CitiesNamedServices();
        $this->supplier = new SupplierServices();

    }
    public function index()
    {
        $country = $this->country->getAll();
        return view('admin.cities.index')->with('country', $country);
    }
    public function search()
    {
        $supp = $this->supplier->getApiSupplierPluck();
        $name = request('name');
        $country = request('country');
        foreach ($supp as $n)
        {
            $data[$n]= $this->comanyCities->search($name,$country,$n);
        }


        return view('admin.cities.partial.cities')->with('data', $data)->with('country',$country);
    }

    public function getMore()
    {
        $name = request('name');
        $country = trim(request('country'));
        $company = request('company');
        $data= $this->comanyCities->search($name,$country,$company);
        return view('admin.cities.partial.more')->with('data', $data);
    }
    public function add(Request $request)
    {
        if($this->cities->add($request->all()))
            return response(['status'=>200]);


        $errors = $this->cities->errors();
        return response(['status'=>201,'data'=>$errors]);
    }
    public function updated(Request $request)
    {
        if($this->cities->updated($request->all()))
            return response(['status'=>200]);


        $errors = $this->cities->errors();
        return response(['status'=>201,'data'=>$errors]);
    }
    public function getCitiesById($id = 0)
    {
        $data = $this->cities->getCities($id);
        return response(['data'=>$data]);
    }

}
