<?php

namespace Modules\Hotel\Sys\ServicesProvidor\TBO;

use App\Http\Resources\HotelResource;
use App\Http\Resources\RoomsResource;
use App\Http\Resources\TBOHotelDetailsResource;
use App\Http\Resources\TBOPreBookResources;
use App\Models\Sessions;
use App\Sys\Services;
use GuzzleHttp\Client;
use Illuminate\Support\Str;
use Modules\Hotel\Sys\Services\hotelDetailsServices;
use function PHPUnit\Framework\isEmpty;

class TBOServices extends Services
{
    use TBOConnection;
    private $hotel;
    private $session;
    public function __construct()
    {
        $this->hotel = new hotelDetailsServices();
        $this->session = new Services\SessionServices();
    }
    public function preparationHotelSearch($data)
    {
        $chiled = $data['children_ages'] != null ? array_map('intval', explode(',', $data['children_ages'])) : [];
        $Adults = $data['adults'] != null ? array_map('intval', explode(',', $data['adults'])) : [];
        $Children = $data['children'] != null ? array_map('intval', explode(',', $data['children'])) : [];
        if (Auth()->guard('api')->check()) {
            $nationality = $data['country'] == 'AE' && Auth()->guard('api')->user()->residency == 'AE' ? 'AE' : Auth()->guard('api')->user()->nationality;
        } else {
            $nationality = $data['guestNationality'];
        }
        $PaxRooms = [];
        $ageIndex = 0;
        for ($i = 0; $i < count($Adults); $i++) {
            $numChildren = isset($Children[$i]) ? (int)$Children[$i] : 0;
            $room = [
                "Adults" => (int)$Adults[$i],
                "Children" => $numChildren,
                "ChildrenAges" => array_slice($chiled, $ageIndex, $numChildren)
            ];
            $ageIndex += $numChildren;
            $PaxRooms[] = $room;
        }
        $filter = [
            'Refundable' => (string)$data['refundable'],
            'NoOfRooms' => 0,
            'MealType' => (string)$data['meal_type'],
        ];
        $HotelCodes = $this->getHotelCodeByCity($data['tbo_city']);
        $parameter = [
            "CheckIn" => $data['check_in'],
            "CheckOut" => $data['check_out'],
            "GuestNationality" => $nationality,
            "PaxRooms" => $PaxRooms,
            "Filters" => $filter,
            "IsDetailedResponse" => true,
            "ResponseTime" => 23.0,
            "Currency" => $data['Currency'] ?? "USD",
            "MinPrice" => 0,
            "MaxPrice" => 0,
            "HotelCodes" => $HotelCodes
            //"cases"=> request()->has('cases') ? request()->cases : request()->attributes->get('guest_id')
        ];
        return $parameter;
    }

    public function preparationRoomSearch($session)
    {
        $search = Sessions::find($session['session_id']);
        $json = json_decode($search->search, true);
        $parameter = $json['tbo'];
        $parameter['HotelCodes'] = (string)$session['required_fields']['hotel_code'];
        return $parameter;
    }

    public function HotelSearch($data)
    {
        $hotel = $this->TBO('POST', 'HotelSearch', $data);
        if ($hotel['Status']['Code'] == 200) {
            $hotelSearchResults['status'] = true;
            $hotelSearchResults['data'] = collect($hotel['HotelSearchResults'])->map(function ($item) {
                return new HotelResource($item, 'tbo');
            });

            return $hotelSearchResults;
        }
        $errors['status'] = false;
        $errors['data'] = $hotel['Status']['Description'] ?? 'Not Found Errors';
        //$errors['Description'] = $hotel['Status']['Description'];
        return $errors;
    }

    public function getHotelCodeByCity($city)
    {
        $pramter = [
            'CityCode' => $city,
            'IsDetailedResponse' => false
        ];
        $hotel_code = $this->TBO('post', 'TBOHotelCodeList', $pramter);
        if ($hotel_code['Status']['Code'] == 200) {
            $limited_hotel_code = array_slice(collect($hotel_code['Hotels'])->pluck('HotelCode')->toArray(), 0, 100);
            return implode(',', $limited_hotel_code);
        }
        return [];
    }

    public function HotelByCity($code, $is_detailed, $layout)
    {
        $pramter = [
            'CityCode' => $code,
            'IsDetailedResponse' => $is_detailed
        ];
        $hotel = $this->TBO('post', 'TBOHotelCodeList', $pramter, 'hotel');
        if ($layout == "array") {
            if ($hotel['Status']['Code'] == 200)
                return collect($hotel['Hotels'])->pluck('HotelCode')->toArray();
            else
                return [];
        }

        return $hotel['Hotels'];
    }

    public function rooms($data)
    {

        $rooms = $this->TBO('POST', 'Search', $data);
        if ($rooms['Status']['Code'] == 200) {
            $hotel = $rooms['HotelResult'][0]['HotelCode'];
            $curr = $rooms['HotelResult'][0]['Currency'];
            $hotelSearchResults['status'] = true;
            $hotelSearchResults['data'] = collect($rooms['HotelResult'][0]['Rooms'])->map(function ($item) use ($hotel, $curr) {
                return new RoomsResource($item, 'tbo', $hotel, $curr);
            });
            return $hotelSearchResults;
        }


        $errors['status'] = false;
        $errors['data'] = $rooms['Status']['Description'] ?? 'Not Found Errors';
        return $errors;
    }

    public function preBooking($data)
    {
       if(isset($data['required_fields']['bookingCode'])&& $data['required_fields']['bookingCode']!=null)
       {
           $pramter = [
               'BookingCode' => $data['required_fields']['bookingCode'],
               'PaymentMode' => $data['required_fields']['payment']
           ];
           $hotel = $this->TBO('post', 'PreBook', $pramter);
           if ($hotel['Status']['Code'] == 200) {
               $hotelSearchResults['status'] = true;
               $hotelSearchResults['data'] = collect($hotel['HotelResult'])->map(function ($item) {
                   return new TBOPreBookResources($item, 'tbo');
               });
               return $hotelSearchResults;
           }
           $errors['status'] = false;
           $errors['Description'] = $hotel['Status']['Description'];
           return $errors;
       }


    }

    public function booking($data)
    {
        /*
        $unwantedKeys = ['rome_name', 'hotel_name', 'check_in', 'check_out', 'room_name'];
        foreach ($unwantedKeys as $key) {
            if (isset($send[$key])) {
                unset($send[$key]);
            }
        }*/
        $session = $data['session_id'];
        foreach ($data['CustomerDetails'] as &$detail) {
            foreach ($detail['CustomerNames'] as &$customer) {
                unset($customer['BirthDate']);
            }
        }
         $send['CustomerDetails'] =$data['CustomerDetails'] ;
         $send['bookingCode'] =$data['required_fields']['bookingCode'] ;
         $send['BookingType'] =$data['required_fields']['BookingType'] ;
         $send['TotalFare'] =$data['required_fields']['TotalFare'] ;
         $send['PaymentMode'] =$data['required_fields']['PaymentMode'] ;
         $send['ClientReferenceId'] =uniqid() . time() . Str::random(5) ;
         $send['BookingReferenceId'] = uniqid() . time() . Str::random(6);
         $send['EmailId'] = $data['EmailId'];
         $send['PhoneNumber'] = $data['PhoneNumber'];
         $search = $this->getSearchData($session);
         $send['guestNationality'] = $search['GuestNationality'];


        $hotel = $this->TBO('post', 'Book', $send);
        if ($hotel['Status']['Code'] == 200) {
            $rueslt['status'] = true;
            $rueslt['data']['client_referenceId'] = $hotel['ClientReferenceId'];
            $rueslt['data']['confirmation_number'] = $hotel['ConfirmationNumber'];
            $rueslt['data']['booking_number'] = null;
            return $rueslt;
        }
        $rueslt['status'] = false;
        $errors['Description'] = $hotel['Status']['Description'];
        return $errors;
    }

    public function getHotel($data)
    {
        if(isset($data['required_fields'])&& $data['required_fields']['hotel_code'] != null)
        {
            $parameter = [
                'Language'=>'EN',
                'Hotelcodes'=>$data['required_fields']['hotel_code']
            ];

            $hotel = $this->hotel->getHotel('tbo',$parameter['Hotelcodes']);
            $result =[];
            $result['status']=true;
            if(!empty($hotel))
            {
                $result['data']=  [new TBOHotelDetailsResource( json_decode($hotel->properties,true), 'tbo')];
                return $result;
            }
             $hotelData = $this->TBO('post', 'HotelDetails', $parameter);
             $this->hotel->addTbo($hotelData['HotelDetails']);
             $result['data']=  [new TBOHotelDetailsResource( $hotelData['HotelDetails'][0], 'tbo')];
            return $result;
        }




    }
    public function getSearchData($id)
    {
        $searchData = $this->session->getFind($id);
        $json = json_decode($searchData->search, true);
        return $parameter = $json['tbo'];
    }
}
