<?php

namespace Modules\Hotel\Sys\ServicesProvidor\MR;

use App\Http\Resources\MRHotelDetailsResource;
use App\Http\Resources\MRHotelResources;
use App\Http\Resources\MRPreBookResources;
use App\Http\Resources\MRRoomsResources;
use App\Sys\Services;

class MRServices extends Services
{
    use MRConnection;

    private $session;

    public function __construct()
    {
        $this->session = new Services\SessionServices();
    }

    // preparationHotelSearch و Search => بيعمل بحث في الهوتيل
    // ملحوظه الشركه ديه مش بتفصل الفنادق والغرف البحث بيكون علي الغرف علي طول
    /**
     * @param $data
     * @return array
     *  هنا بظبط الداتا علشان تكون جاهزه علي السرش علي طول
     */
    public function preparationHotelSearch($data)
    {
        $chiled = $data['children_ages'] != null ? array_map('intval', explode(',', $data['children_ages'])) : [];
        $Adults = $data['adults'] != null ? array_map('intval', explode(',', $data['adults'])) : [];
        $Children = $data['children'] != null ? array_map('intval', explode(',', $data['children'])) : [];
        if (Auth()->guard('api')->check()) {
            $nationality = $data['country'] == 'AE' && Auth()->guard('api')->user()->residency == 'AE' ? 'AE' : Auth()->guard('api')->user()->nationality;
        } else {
            $nationality = $data['guestNationality'];
        }
        $PaxRooms = [];
        $ageIndex = 0;
        for ($i = 0; $i < count($Adults); $i++) {
            $numChildren = isset($Children[$i]) ? (int)$Children[$i] : 0;
            $room = [
                "adults" => (int)$Adults[$i],
                "children" => array_slice($chiled, $ageIndex, $numChildren)
            ];
            $ageIndex += $numChildren;
            $PaxRooms[] = $room;
        }
        $city = $data['mr_city'];
        $parameter = [
            "checkIn" => $data['check_in'],
            "checkOut" => $data['check_out'],
            "nationality" => $nationality,
            "rooms" => $PaxRooms,
            "cityId" => $city,
            "category" => "0",
            "noimages" => false,
            "cheapestonly" => true,
            "cutofftime" => "30"
        ];
        return $parameter;
    }

    /**
     * @param $data
     * @param $session_id
     * @return array
     *  هنا عمليه السرش نفسها
     */
    public function Search($data, $session_id)
    {

        // get sessionToken
        $token = $this->MR('get', null, 'gettoken', null);
        if ($token != null && !isset($token['error'])) {

            $this->SaveToken($session_id, $token);
            $rueslt = $this->MR('POST', $token['accessToken'], 'hotels/onestepsearch', $data);
            $hotelSearchResults = [];
            if ($rueslt != null && isset($rueslt['data'])) {
                $hotelSearchResults['status'] = true;
                $hotelSearchResults['data'] = collect($rueslt['data']['entities'])->map(function ($item) {
                    return new MRHotelResources($item, 'mr');
                });

                return $hotelSearchResults;

            }
            $errors['status'] = false;
            $errors['data'] = $rueslt['errors']['message'] ?? 'Not Found Errors';
            //$errors['Description'] = $hotel['Status']['Description'];
            return $errors;
        }
        $errors['status'] = false;
        $errors['data'] = 'cant get Token';
        return $errors;

    }

    public function preparationRoomSearch($data)
    {
        return $data;
    }

    public function rooms($data)
    {
        $session = $data['session_id'];
        $item = $data['required_fields']['itemId'];
        $accessToken = $this->getAccessToken($session);
        $url = 'hotels/items/' . $item . '/rooms';
        $parr = ['page' => 1, 'timeout' => 60, 'displaycount' => 100, 'groupby' => 'no'];
        $rueslt = $this->MR('get', $accessToken, $url, $parr);
        $hotelSearchResults = [];
        if ($rueslt != null && isset($rueslt['data'])) {
            $hotelSearchResults['status'] = true;
            $hotelSearchResults['data'] = collect($rueslt['data']['entities'])->map(function ($item) {
                return new MRRoomsResources($item, 'mr');
            });

            return $hotelSearchResults;

        }
        $errors['status'] = false;
        $errors['data'] = $rueslt['errors']['message'] ?? 'Not Found Errors';
        //$errors['Description'] = $hotel['Status']['Description'];
        return $errors;


    }

    // ديه بترجع hotel بياناته كلها ملحوظه مش بقدر اعمل save في db علشان كدا كدا مش بعرف اجيب الهوديل ب الكود بتاعه
    public function hotel($data)
    {

        $session = $data['session_id'];
        $item = $data['required_fields']['itemId'];
        $accessToken = $this->getAccessToken($session);
        $url = 'hotels/items/' . $item . '/details';

        $rueslt = $this->MR('get', $accessToken, $url, null);

        $hotelSearchResults = [];
        if ($rueslt != null && isset($rueslt['data'])) {
            $hotelSearchResults['status'] = true;
            $hotelSearchResults['data'] = [new MRHotelDetailsResource($rueslt['data']['properties'], 'mr')];
            /*
            collect(($rueslt['data']['properties']))->map(function ($item) {
            return new MRHotelDetailsResource($item, 'mr');
        });
            */
            return $hotelSearchResults;

        }
        $errors['status'] = false;
        $errors['data'] = $rueslt['errors']['message'] ?? 'Not Found Errors';
        //$errors['Description'] = $hotel['Status']['Description'];
        return $errors;

    }

    public function preBook($data)
    {
        $session = $data['session_id'];
        $item = $data['required_fields']['itemId'];
        $solutionId = $data['required_fields']['solutionId'];
        $accessToken = $this->getAccessToken($session);
        $url = 'hotels/items/' . $item . '/rooms/' . $solutionId . '/select';
        $rueslt = $this->MR('get', $accessToken, $url, null);

        $hotelSearchResults = [];
        if ($rueslt != null && isset($rueslt['data'])) {
            $hotelSearchResults['status'] = true;
            $hotelSearchResults['data'] = [new MRPreBookResources($rueslt['data'], 'mr')];
            return $hotelSearchResults;

        }
        $errors['status'] = false;
        $errors['data'] = $rueslt['errors']['message'] ?? 'Not Found Errors';
        //$errors['Description'] = $hotel['Status']['Description'];
        return $errors;

    }

    public function booking($data)
    {

        // اظبط البسنجر لل دا بيفهمها
        // محتاج الجنسيه
        $session = $data['session_id'];
        $item = $data['required_fields']['itemId'];
        $solutionId = $data['required_fields']['solutionId'];
        $accessToken = $this->getAccessToken($session);
        $search = $this->getSearchData($data['session_id']);
        $passange['passengers'] = $this->passangers($data['CustomerDetails'], $search['nationality']);
        $passange['contact'] = [
            "title" => "MR",
            "firstName" => "Contact",
            "lastName" => "Person",
            "phone" => $data['PhoneNumber'],
            "email" => $data['EmailId'],
            "country" => null,
            "zip" => null,
            "city" => null,
            "address" => null
        ];
        $passange['invoice'] = [
            "name" => "Multiresisen Gmbh.",
            "country" => "DE",
            "zip" => "34663",
            "city" => "Berlin",
            "address" => "Some street 1."
        ];
        $passange['paymentId'] = $data['required_fields']['paymentId'];
        $url = 'hotels/items/' . $item . '/rooms/' . $solutionId . '/passengers';
        $rueslt = $this->MR('post', $accessToken, $url, $passange);
        if ($rueslt != null && isset($rueslt['data'])) {
            $bookingId = $rueslt['data']['bookingId'];
            $Finalize = 'hotels/items/' . $item . '/rooms/' . $solutionId . '/book/' . $bookingId;
            $final = $this->MR('PUT', $accessToken, $Finalize, null);
            if ($final != null && isset($final['data'])) {
                $bookingDetials['status'] = true;
                $bookingDetials['data'] = [
                    'company'=>'mr',
                    'client_referenceId' => $final['data']['bookings']['bookingCode'],
                    'confirmation_number' => $final['data']['bookingId'], //booking_id
                    'booking_number'=>$final['data']['bookings']['bookingNumber']
                ];
                return $bookingDetials;
            }
            $errors['status'] = false;
            $errors['data'] = $final['errors']['message'] ?? 'Not Found Errors';
            return $errors;
        }
        $errors['status'] = false;
        $errors['data'] = $rueslt['errors']['message'] ?? 'Not Found Errors';
        return $errors;

    }

    public function SaveToken($session_id, $token)
    {

        return $this->session->addNewToken('mr', 'accessToken', $token['accessToken'], $session_id, null);
    }

    public function getAccessToken($session_id)
    {
        $accessToken = $this->session->getTokenBySessionID($session_id, 'accessToken', 'mr');
        return $accessToken->value ?? null;
    }

    public function getSearchData($id)
    {
        $searchData = $this->session->getFind($id);
        $json = json_decode($searchData->search, true);
        return $parameter = $json['mr'];
    }

    public function passangers($data, $ng)
    {
        $convertedData = [];

        foreach ($data as $entry) {
            if (isset($entry['CustomerNames']) && is_array($entry['CustomerNames'])) {
                foreach ($entry['CustomerNames'] as $customer) {
                    $convertedData[] = [
                        "type" => $customer["Type"] == "Adult" ? "ADT" : "CHD",
                        "title" => $customer["Title"],
                        "firstName" => $customer["FirstName"],
                        "lastName" => $customer["LastName"],
                        "birthDate" => $customer["BirthDate"],
                        "nationality" => $ng
                    ];
                }
            }
        }
        return $convertedData;
    }

}
