<?php

namespace Modules\Hotel\Sys\ServicesProvidor\MR;

use App\Sys\Services\SupplierServices;
use GuzzleHttp\Client;

trait MRConnection
{
    public function MR($method = "get", $token = null, $endpoint, $parameter = null)
    {
        $client = new Client();
        if($cred = $this->getCredentials())
        {
            $point = $cred['url'] . '/' . $endpoint;
            $options = [
                'headers' => [
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json',
                    'Authorization' => $cred['authorization']
                ],
            ];
            if ($token != null)
            {
                $options['headers']['AccessToken']=$token;
                $options['headers']['Version']='v1';

            }

            if (in_array(strtoupper($method), ['POST', 'PUT'])) {
                $options['json'] = $parameter;
            } else {
                $options['query'] = $parameter;
            }

            $response = $client->request($method, $point, $options);
            return json_decode($response->getBody(), true);
        }
        return false;
    }

    private function getCredentials()
    {
        $spSupplier = new SupplierServices();
        $credentials = $spSupplier->getCredentials('mr');
        if(!empty($credentials))
        {
            return [
                'url'=>$credentials->hotel_api_url,
                'username'=>$credentials->hotel_api_username,
                'password'=>$credentials->hotel_api_password,
                'authorization'=>$credentials->hotel_api_authorization
            ];
        }

        return false;
    }
}
