<?php

namespace Modules\Hotel\Sys\Services;

use App\Models\Result;
use App\Models\searchResult;
use App\Models\SessionFirst;
use App\Models\Sessions;
use App\Sys\Services;
use App\Sys\Services\SessionServices;
use App\Sys\Services\SupplierServices;
use App\Sys\Services\staticData\cities\CitiesNamedServices;
use GuzzleHttp\Promise;
use GuzzleHttp\Client;
use Illuminate\Support\Arr;
use Carbon;
use Modules\Hotel\App\Events\SaveFinshedHotel;
use Modules\Hotel\App\Events\SearchMR;
use Modules\Hotel\Sys\ServicesProvidor\TBO\test;
use Illuminate\Support\Facades\Bus;
use Modules\Hotel\App\Events\SearchTBO;
use Illuminate\Support\Facades\Event;
use Spatie\Async\Pool;


class HotelServices extends Services
{
    private $suppliers;
    private $config;
    private $city;
    private $session;
    public function __construct()
    {
        $this->suppliers = new SupplierServices();
        $this->config = config('hotel');
        $this->city = new CitiesNamedServices();
        $this->session = new SessionServices();
    }
    public function search($data)
    {
        if (isset($data['session_id']) && $data['session_id'] != null)
            return $this->oldSearch($data);


        return $this->firstSearch($data);
    }

    public function oldSearch($data)
    {

        $h = Result::where([['guest_id', $data['session_id']], ['type', 'hotel']])->first();
        if (!empty($h)) {
            if($h->status == 1)
            {
                $hotelData = json_decode($h->properties);
                $count = count($hotelData);
                $page = $data['page']??1;
                $perPage = $data['per_page']??10;
                $totalPages = ceil($count / $perPage);
                $offset = ($page - 1) * $perPage;

                $rueslt['default-min'] = $count > 0 ? (float)collect($hotelData)->min('price') : 0;
                $rueslt['default-max'] = $count > 0 ? (float)collect($hotelData)->max('price') : 0;
                // check prices data
                if (((isset($search['min']) && $search['min'] != null) && (isset($search['max']) && $search['max'] != null)) || (isset($data['hotel_name']) && $data['hotel_name'] != null))
                    $hotelData = $this->fillterPrices($search['min'], $search['max'], $hotelData, $data['hotel_name']);


                $rueslt['data'] = array_slice((array)$hotelData, $offset, $perPage);
                $rueslt['count'] = count((array)$hotelData);
                $rueslt['search-min'] = isset($search['min']) && $search['min'] != null ? (int)$search['min'] : $rueslt['default-min'];
                $rueslt['search-max'] = isset($search['max']) && $search['max'] != null ? (int)$search['max'] : $rueslt['default-max'];
                $rueslt['session_id'] = $h->guest_id;
                $rueslt['data_complete'] = 'yes';
                return $rueslt;
            }
            $this->setError($h->properties[0]);
            return false;

        }
        event(new SaveFinshedHotel($data['session_id']));

          return  $this->getFirstData($data);
      //  return $this->firstSearch($data);

    }

    public function fillter($data)
    {
        if (isset($data['session_id']) && $data['session_id'] != null)
        {
            // check data :)
            if($data =$this->oldSearch($data))
            {
                return $data;
            }
           return false;
        }
        $this->setError(['Places need Session_id']);
        return false;

    }

    public function getFirstData($data)
    {
        $h = SessionFirst::where([
            ['session_id',$data['session_id']],
            ['status',1]
        ])->first();
        if(!empty($h))
        {
            $get = json_decode($h->result,true);
            $hotelData= $get['data'];
            $count = count($hotelData);
            $page = $data['page']??1;
            $perPage = $data['per_page']??10;
            $totalPages = ceil($count / $perPage);
            $offset = ($page - 1) * $perPage;

            $rueslt['default-min'] = $count > 0 ? (float)collect($hotelData)->min('price') : 0;
            $rueslt['default-max'] = $count > 0 ? (float)collect($hotelData)->max('price') : 0;
            // check prices data
            if (((isset($search['min']) && $search['min'] != null) && (isset($search['max']) && $search['max'] != null)) || (isset($data['hotel_name']) && $data['hotel_name'] != null))
                $hotelData = $this->fillterPrices($search['min'], $search['max'], $hotelData, $data['hotel_name']);


            $rueslt['data'] = array_slice((array)$hotelData, $offset, $perPage);
            $rueslt['count'] = count((array)$hotelData);
            $rueslt['search-min'] = isset($search['min']) && $search['min'] != null ? (int)$search['min'] : $rueslt['default-min'];
            $rueslt['search-max'] = isset($search['max']) && $search['max'] != null ? (int)$search['max'] : $rueslt['default-max'];
            $rueslt['session_id'] = $h->guest_id;
            $rueslt['data_complete'] = 'no';
            return $rueslt;
        }

        return false;

    }

    public function mappingData($session)
    {

        $data = $this->session->getFirstRueslteData($session);
        if($data['status'] == true)
        {
            $property = [];
            foreach ($data['data'] as $d)
            {
                $property = array_merge($property,$d['data']);
            }
        }else{
            $property= $data['data']['data'][0];
        }

        $add = new Result();
        $add->guest_id = $session;
        $add->is_active = 1;
        $add->type = 'hotel';
        $add->status = $data['status'] == true ? 1 : 0;
        $add->properties = $property;
        $add->save();
         $this->session->updatedSe($session);
         return $add;
    }
    public function firstSearch($data)
    {
        $prepared = $this->hotelPreparedData($data);
         if($hotel = $this->hotelSearch($prepared))
             return $hotel;

        /*
        if($rueslt = $this->saveSessions($hotel,$data))
            return  $rueslt;
        */

        return false;
    }

    public function saveSessions($hotel, $search)
    {
        $well = [];
        $haveErrors = [];
        foreach ($hotel as $item) {
            if ($item['status'] == true)
                $well[] = $item['data'];
            else
                $haveErrors[] = $item['data'];
        }
        if (!empty($well)) {
            // save data statr seesion id
            $hotelData = $well[0];
            $session = $this->session->add(['exp' => null]);
            $count = count($hotelData);
            $page = request()->page;
            $perPage = request()->per_page;
            $totalPages = ceil($count / $perPage);
            $offset = ($page - 1) * $perPage;
            // add data

            $data = $this->save($hotelData, $session);
            $hotels = json_decode($data->properties);

            $rueslt['default-min'] = $count > 0 ? (float)collect($hotels)->min('price') : 0;
            $rueslt['default-max'] = $count > 0 ? (float)collect($hotels)->max('price') : 0;


            if (((isset($search['min']) && $search['min'] != null) && (isset($search['max']) && $search['max'] != null)) || (isset($search['hotel_name']) && $search['hotel_name'] != null))
                $hotels = $this->fillterPrices($search['min'], request()->max, $hotels, $search['hotel_name']);


            $rueslt['data'] = array_slice((array)$hotels, $offset, $perPage);
            $rueslt['count'] = count((array)$hotels);
            $rueslt['search-min'] = isset($search['min']) && $search['min'] != null ? (int)$search['min'] : $rueslt['default-min'];
            $rueslt['search-max'] = isset($search['max']) && $search['max'] != null ? (int)$search['max'] : $rueslt['default-max'];
            $rueslt['session_id'] = $session;
            return $rueslt;


        }

        $errors = $haveErrors[0] ?? 'Not Found Errors';
        $this->setError($errors);
        return false;
    }

    private function save($data, $id)
    {
        $h = Result::where([['guest_id', $id], ['type', 'hotel']])->first();
        if (!empty($h)) {
            $h->delete();
        }

        $addHotel = new Result();
        $addHotel->properties = $data;
        $addHotel->guest_id = $id;
        $addHotel->search = json_encode(Arr::except(request()->all(), ['page', 'per_page', 'min', 'max', 'hotel_name', 'session_id']));
        $addHotel->is_active = 1;
        $addHotel->type = 'hotel';
        $addHotel->save();
        return $addHotel;
    }

    public function fillterPrices($min, $max, $data, $name)
    {
        $mixR = $min != null ? $min : (float)collect($data)->min('price');
        $maxR = $min != null ? $max : (float)collect($data)->max('price');
        $filteredHotels = collect($data)->filter(function ($hotel) use ($mixR, $maxR, $name) {
            if ($name != null)
                return $hotel->price >= $mixR && $hotel->price <= $maxR && stripos($hotel->hotel_name, $name) !== false;

            return $hotel->price >= $mixR && $hotel->price <= $maxR;
        });


        return json_decode($filteredHotels);
    }

    private function hotelPreparedData($data)
    {
        // $supp = all suppliers
        $supp = $this->supplier();
        $code = $this->getCities($data['city']);
        $preparedData = [];
        //s => supplier
        foreach ($supp as $s) {
            $prepared_data = $this->config['Search']['prepared_search_hotel'][$s] ?? null;
            $data[$s . "_city"] = $code[$s];
            if (!empty($prepared_data) && $data[$s . "_city"] != null) {
                $class = $prepared_data['class'];
                $method = $prepared_data['method'];
                if (class_exists($class) && method_exists($class, $method)) {
                    $instance = new $class();
                    //$preparedData[$s] = call_user_func_array([$instance, $method], [$data]);
                    $preparedData[$s] = call_user_func_array([$instance, $method], [$data]);
                }
            }

        }
        return $preparedData;
    }

    private function hotelSearch($data)
    {

        // نعملها global var
        $supp = $this->supplier();
        // add session_id
        $session = $this->session->add(['search'=>$data,'exp' => null]);
        $preparedData = [];
        foreach ($supp as $s) {
            $prepared_data = $this->config['Search']['hotel_search'][$s] ?? null;

            if (!empty($prepared_data) && $data[$s] != null) {
                $last = $s === end($supp) ? true: false;
                event(new $this->config['Search']['hotel_search'][$s]($session,$data[$s],$last));
                /*
                $class = $prepared_data['class'];
                $method = $prepared_data['method'];
                if (class_exists($class) && method_exists($class, $method)) {
                    $instance = new $class();
                    $preparedData[$s] = call_user_func_array([$instance, $method], [$data[$s], $session]);
                }
                */
            }

        }
        return $session;


        /*
        $promises = [];
        $firstResult = null;

        // تجهيز الطلبات
        foreach ($this->supplier() as $s) {
            $prepared_data = $this->config['Search']['hotel_search'][$s] ?? null;

            if (!empty($prepared_data) && isset($data[$s])) {
                $class = $prepared_data['class'];
                $method = $prepared_data['method'];

                if (class_exists($class) && method_exists($class, $method)) {
                    $instance = new $class();

                    // إضافة Promise إلى المصفوفة
                    $promises[$s] = new Promise(function ($resolve, $reject) use ($instance, $method, $data, $s) {
                        try {
                            $result = call_user_func_array([$instance, $method], [$data[$s]]);
                            $resolve([$s => $result]);
                        } catch (\Exception $e) {
                            $reject($e);
                        }
                    });
                }
            }
        }
        $session_id = 1 ;
        // معالجة النتائج
        $promiseArray =  Promise\settle($promises)->then(function ($responses) use ($session_id, &$firstResult) {
            $currentResults = [];

            foreach ($responses as $supplier => $result) {
                if ($result['state'] === 'fulfilled') {
                    if (!$firstResult) {
                        $firstResult = $result['value'];
                    }
                    $currentResults[$supplier] = $result['value'];
                    cache()->put("hotel_search_results_{$session_id}", $currentResults, 300);
                }
            }

            if (!empty($currentResults)) {
                $this->updateSessionPropert($session_id, $currentResults);
            }
        })->wait(false) ?: $firstResult; // إرجاع أول نتيجة
        return $firstResult;
        */

        /*

        $supp = $this->supplier();
        $fibers = [];
        $client = new Client();
        $responses = [];
        $promises = [];

        // إعداد الطلبات
        foreach ($supp as $s) {
            $prepared_data = $this->config['Search']['hotel_search'][$s] ?? null;

            if (!empty($prepared_data) && !empty($data[$s])) {
                $class = $prepared_data['class'];
                $method = $prepared_data['method'];

                if (class_exists($class) && method_exists($class, $method)) {
                    $instance = new $class();

                    // استخدام method لتنفيذ الطلب
                    $promises[$s] = new \GuzzleHttp\Promise\Promise(function ($resolve, $reject) use ($instance, $method, $data, $s) {
                        try {
                            // هنا يمكنك استدعاء الدالة التي تعالج الطلبات
                            $result = call_user_func([$instance, $method], $data[$s]);
                            $resolve([$s => $result]);
                        } catch (\Exception $e) {
                            $reject([$s => 'Error: ' . $e->getMessage()]);
                        }
                    });
                }
            }
        }



        // بدء تنفيذ الطلبات
        $firstResponse = null;
        $settledPromises = Promise\settle($promises)->wait();

        // معالجة الاستجابات
        foreach ($settledPromises as $supplier => $result) {
            if ($result['state'] === 'fulfilled') {
                // أخذ أول استجابة
                if (!$firstResponse) {
                    $firstResponse = $result['value'];
                }
                // تخزين الاستجابة في المصفوفة
                $responses[$supplier] = $result['value'];
            } else {
                // معالجة الأخطاء
                $responses[$supplier] = ['error' => $result['reason']->getMessage()];
            }
        }

        // إعادة أول استجابة
        return $firstResponse;

        // بعد إرجاع أول استجابة، يمكنك معالجة بقية الاستجابات
        // وتخزينها في قاعدة البيانات
        $this->updateSessionPropert($responses);
        */
    }


    protected function updateSessionPropert($sessionId, array $results)
    {
        return 'yes';
        $finalData = json_encode($results);
        \DB::table('session')
            ->where('id', $sessionId)
            ->update(['propert' => $finalData]);
    }

    private function supplier()
    {
        $supp = $this->suppliers->getApiSupplier('hotel');

        return $supp->pluck('alias_name')->toArray();
    }
    public function getCities($city)
    {
        return $this->city->getCodeCity($city);
    }
    public function testSearch()
    {

        $session = $this->session->add(['exp' => null]);
        $supp = $this->supplier();
        $pool = Pool::create();
        foreach ($supp as $s) {

            if (isset($this->config['testSearch'][$s])) {
                $x = new $this->config['testSearch'][$s]['class'];
                $method = $this->config['testSearch'][$s]['method'];
                $pool->add(fn() => $x->$method($session));
            }
        }
        return $session;
    }

    public function test2($session)
    {
        $x = new test();
        $hotel = $x->getTbo();
        $new = new searchResult();
        $new->session_id = $session;
        $new->company = 'tbo';
        $new->status = $hotel['status'] == true ? 1 : 0;
        $new->property = json_encode($hotel['data'][0]);
        $new->save();
    }


}
