<?php

namespace Modules\Hotel\App\Listeners;

use App\Models\searchResult;
use App\Models\SessionFirst;
use App\Sys\Repository\SessionsRepo;
use App\Sys\Services\SessionServices;
use Modules\Hotel\App\Events\SaveFinshedHotel;
use Modules\Hotel\App\Events\SearchTBO;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Modules\Hotel\Sys\ServicesProvidor\TBO\TBOServices;
use Modules\Hotel\Sys\ServicesProvidor\TBO\test;

class SearchTBOListener implements ShouldQueue
{
    /**
     * Create the event listener.
     */

    use InteractsWithQueue;

    /**
     * Handle the event.
     */
    public function handle(SearchTBO $event): void
    {
        // save in

        $tboServices = new TBOServices();
        $result = $tboServices->HotelSearch($event->data);
        $status = $result['status'] == true ? 1 : 0;
        $add = new SessionFirst();
        $add->session_id = $event->session_id;
        $add->company = 'tbo';
        $add->result = json_encode($result);
        $add->status = $status;
        $add->complete = 0;
        $add->save();
        /*
        $sessionServices = new SessionServices();
        $sessionServices->addSessioninFirstTable('tbo', $result['data'], $status, $event->session_id);
        */
        // run Data Mapping
        if ($event->last == true) {
            event(new SaveFinshedHotel($event->session_id));
        }



        /*
        $x = new test();
        $hotel = $x->getTbo();
        $new = new searchResult();
        $new->session_id = $event->session_id;
        $new->company = 'tbo';
        $new->status = $hotel['status'] == true ? 1 : 0;
        $new->property = json_encode($hotel['data'][0]);
        $new->save();
         */

    }
}
