<?php

namespace Modules\Hotel\App\Listeners;

use App\Models\searchResult;
use App\Models\SessionFirst;
use App\Sys\Services\SessionServices;
use Modules\Hotel\App\Events\SaveFinshedHotel;
use Modules\Hotel\App\Events\SearchMR;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Modules\Hotel\Sys\ServicesProvidor\MR\MRServices;

class SearchMRListener implements ShouldQueue
{
    /**
     * Create the event listener.
     */

    use InteractsWithQueue;

    /**
     * Handle the event.
     */
    public function handle(SearchMR $event): void
    {

        $mr = new MRServices();
        $result = $mr->Search($event->data, $event->session_id);
        $status = $result['status'] == true ? 1 : 0;
        $add = new SessionFirst();
        $add->session_id = $event->session_id;
        $add->company = 'mr';
        $add->result = json_encode($result);
        $add->status = $status;
        $add->complete = 0;
        $add->save();

        /**
        $sessionServices = new SessionServices();
        $sessionServices->addSessioninFirstTable('mr', $result['data'], $status, $event->session_id);
         * */

        if ($event->last == true) {
            event(new SaveFinshedHotel($event->session_id));
        }
        /*
        $x = new test();
        $hotel = $x->getMR();
        $new = new searchResult();
        $new->session_id = $event->session_id;
        $new->company = 'mr';
        $new->status = $hotel['status'] == true ? 1 : 0;
        $new->property = json_encode($hotel['data'][0]);
        $new->save();
        */
    }
}
