<?php

namespace Modules\Hotel\App\Jobs;

use App\Models\searchResult;
use App\Models\SessionFirst;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Modules\Hotel\App\Events\SaveFinshedHotel;
use Modules\Hotel\Sys\ServicesProvidor\TBO\TBOServices;
use Modules\Hotel\Sys\ServicesProvidor\TBO\test;
use Illuminate\Bus\Batchable;
class SearchApi implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels,Batchable;

    public $session_id;

    /**
     * Create a new job instance.
     */
    public function __construct($id)
    {
        $this->session_id = $id;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $tboServices = new TBOServices();
        $result = $tboServices->HotelSearch($event->data);
        $status = $result['status'] == true ? 1 : 0;
        $add = new SessionFirst();
        $add->session_id = $event->session_id;
        $add->company = 'tbo';
        $add->result = json_encode($result);
        $add->status = $status;
        $add->complete = 0;
        $add->save();
        /*
        $sessionServices = new SessionServices();
        $sessionServices->addSessioninFirstTable('tbo', $result['data'], $status, $event->session_id);
        */
        // run Data Mapping
        if ($event->last == true) {
            event(new SaveFinshedHotel($event->session_id));
        }

    }
}
