<?php

namespace Modules\Hotel\App\Jobs;

use App\Models\searchResult;
use App\Models\SessionFirst;
use Illuminate\Bus\Batchable;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Modules\Hotel\App\Events\SaveFinshedHotel;
use Modules\Hotel\Sys\ServicesProvidor\MR\MRServices;
use Modules\Hotel\Sys\ServicesProvidor\TBO\test;

class MrApi implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels,Batchable;
    public $session_id;
    public $data;
    public $last;
    /**
     * Create a new job instance.
     */
    public function __construct($id,$data,$last)
    {
        $this->session_id = $id;
        $this->data = $data;
        $this->last = $last;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $mr = new MRServices();
        $result = $mr->Search($this->data, $this->session_id);
        $status = $result['status'] == true ? 1 : 0;
        $add = new SessionFirst();
        $add->session_id = $this->session_id;
        $add->company = 'mr';
        $add->result = json_encode($result);
        $add->status = $status;
        $add->complete = 0;
        $add->save();

        /**
        $sessionServices = new SessionServices();
        $sessionServices->addSessioninFirstTable('mr', $result['data'], $status, $event->session_id);
         * */

        if ($this->last == true) {
            event(new SaveFinshedHotel($event->session_id));
        }
    }


}
