<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Session;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/




Route::get('/',  function (){
    return view('welcome');
});
Route::namespace('admin')->prefix('admin')->group(function () {
    Route::prefix('cities')->group(function () {
        Route::get('/', 'citiesControllers@index')->name('cities.index');
        Route::get('/search', 'citiesControllers@search')->name('cities.search');
        Route::get('/getMore', 'citiesControllers@getMore')->name('cities.getMore');
        Route::get('/getCities/{id}', 'citiesControllers@getCitiesById')->name('cities.getCitiesById');
        Route::post('/add', 'citiesControllers@add')->name('cities.add');
        Route::post('/updated', 'citiesControllers@updated')->name('cities.updated');
    });
    Route::prefix('my-city')->group(function () {
        Route::get('/', 'cityNamedControllers@index')->name('city.index');
        Route::get('/search', 'cityNamedControllers@search')->name('city.search');
        Route::get('/show/{id}', 'cityNamedControllers@Show')->name('city.show');
    });


});
