@extends('admin.layout.index')
@section('title')
     {{__('messages.slider')}}
@endsection
@section('css')
    <style>
        .loader svg {
            width: 3.25em;
            transform-origin: center;
            animation: rotate4 2s linear infinite;
        }

        .loader circle {
            fill: none;
            stroke: hsl(214, 97%, 59%);
            stroke-width: 2;
            stroke-dasharray: 1, 200;
            stroke-dashoffset: 0;
            stroke-linecap: round;
            animation: dash4 1.5s ease-in-out infinite;
        }

        @keyframes rotate4 {
            100% {
                transform: rotate(360deg);
            }
        }

        @keyframes dash4 {
            0% {
                stroke-dasharray: 1, 200;
                stroke-dashoffset: 0;
            }

            50% {
                stroke-dasharray: 90, 200;
                stroke-dashoffset: -35px;
            }

            100% {
                stroke-dashoffset: -125px;
            }
        }

    </style>
    <link rel="stylesheet" href="https://www.jsdelivr.com/package/npm/font-awesome-animation">
@endsection
@section('page-title')
    {{__('messages.slider')}}
@endsection
@section('content')
    <div class="col-12">
        <div class="box box-default">
            <div class="box-header with-border">
                <h4 class="box-title">Step wizard with validation</h4>
                <h6 class="box-subtitle">You can us the validation like what we did</h6>
            </div>
            <!-- /.box-header -->
            <div class="box-body wizard-content">
                <form action="#" class="validation-wizard wizard-circle">
                    <input type="hidden" name="_token" value="{{csrf_token()}}">
                    <!-- Step 1 -->
                    <h6>{{__('messages.lang-ar')}} </h6>

                    <section>
                        <div class="row" id="loadingClass" style="display: none;">
                            <div class="col-12 loader d-flex align-items-center justify-content-center">
                                <svg viewBox="25 25 50 50">
                                    <circle r="20" cy="50" cx="50"></circle>
                                </svg>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customFile"> {{__('messages.photo')}} : <span class="danger">*</span> </label>
                                    <input type="file" class="form-control" id="customFile">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="wlastName2"> Last Name : <span class="danger">*</span> </label>
                                    <input type="text" class="form-control required" id="wlastName2" name="lastName"> </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="wemailAddress2"> Email Address : <span class="danger">*</span> </label>
                                    <input type="email" class="form-control required" id="wemailAddress2" name="emailAddress"> </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="wphoneNumber2">Phone Number :</label>
                                    <input type="tel" class="form-control" id="wphoneNumber2"> </div>
                            </div>
                        </div>
                    </section>
                    <!-- Step 2 -->
                    <h6>Step 2</h6>
                    <section>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="jobTitle3">Company Name :</label>
                                    <input type="text" class="form-control required" id="jobTitle3">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="webUrl3">Company URL :</label>
                                    <input type="url" class="form-control required" id="webUrl3" name="webUrl3"> </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="shortDescription3">Short Description :</label>
                                    <textarea name="shortDescription" id="shortDescription3" rows="6" class="form-control"></textarea>
                                </div>
                            </div>
                        </div>
                    </section>
                    <!-- Step 3 -->
                    <h6>Step 3</h6>
                    <section>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="wint1">Interview For :</label>
                                    <input type="text" class="form-control required" id="wint1"> </div>
                                <div class="form-group">
                                    <label for="wintType1">Interview Type :</label>
                                    <select class="custom-select form-control required" id="wintType1" data-placeholder="Type to search cities" name="wintType1">
                                        <option value="Banquet">Normal</option>
                                        <option value="Fund Raiser">Difficult</option>
                                        <option value="Dinner Party">Hard</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="wLocation1">Location :</label>
                                    <select class="custom-select form-control required" id="wLocation1" name="wlocation">
                                        <option value="">Select City</option>
                                        <option value="India">India</option>
                                        <option value="USA">USA</option>
                                        <option value="Dubai">Dubai</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="wjobTitle4">Interview Date :</label>
                                    <input type="date" class="form-control required" id="wjobTitle4">
                                </div>
                                <div class="form-group">
                                    <label>Requirements :</label>
                                    <input name="group2" type="radio" id="radio_3" value="1">
                                    <label for="radio_3" class="d-block">Employee</label>
                                    <input name="group2" type="radio" id="radio_4" value="1">
                                    <label for="radio_4">Contract</label>
                                </div>
                            </div>
                        </div>
                    </section>
                </form>
            </div>
            <!-- /.box-body -->
        </div>
    </div>
@endsection
@section('js')
    <script src="{{url('panel/assets/vendor_components/jquery-steps-master/build/jquery.steps.js')}}"></script>
    <script src="{{url('panel/assets/vendor_components/jquery-validation-1.17.0/dist/jquery.validate.min.js')}}"></script>
    <script>
        var form = $(".validation-wizard").show();

        localStorage.setItem("x", true);
        $(".validation-wizard").steps({
            headerTag: "h6"
            , bodyTag: "section"
            , transitionEffect: "none"
            , titleTemplate: '<span class="step">#index#</span> #title#',
            loadingTemplate: '<span class="spinner"></span> #text#'
            , labels: {
                finish: "Submit",
                loading: "Loading ..."
            },
            // ... (rest of the configuration)
            onStepChanging: function (event, currentIndex, newIndex) {

                if (currentIndex < newIndex) {
                    // console.log(validateStep(currentIndex))
                    return validateStep(currentIndex);
                }else{
                    return currentIndex > newIndex
                }
            },
            onStepChanged: function (event, currentIndex, priorIndex) { }
            , onFinished: function (event, currentIndex) {
                // Handle form submission
                submitForm();
            },

        });


        function validateStep(currentIndex) {
            showLoading();
            var formData = $(".validation-wizard").serializeArray();
            formData.push({name: "current_index", value: currentIndex});
            $.ajax({
                type: "POST",
                url: "{{ route('slider.valid.step') }}",
                data: formData,
                before:function (){
                    // $('#loadingClass').css("display", "block");
                },
                success: function (response) {
                    if (response.success) {
                        // Proceed to the next step on success
                        localStorage.setItem("x", true);
                        $(".validation-wizard").steps("next");
                    } else if (response.errors) {
                        // Handle errors, e.g., display error messages
                        console.log(response.data);

                        // Reset localStorage to false
                        localStorage.setItem("x", false);
                    }
                },
                error: function (error) {
                    // Handle AJAX call failure
                    console.error(error);

                    // Reset localStorage to false
                    localStorage.setItem("x", false);
                },

            });
            hideLoading();
            return localStorage.getItem("x") === "true";
        }
        function submitForm()
        {
            alert('yes');
        }

        function showLoading() {
            // Display Bootstrap spinner over the entire body
            $('#loadingClass').css("display", "block");
        }

        function hideLoading() {
            $('#loadingClass').css("display", "none");
        }
    </script>
@endsection
