@extends('admin.layout.index')
@section('title')
    {{ __('messages.static_page') }}
@endsection
@section('content')

    <!-- Content Header (Page header) -->

    <div class="content-header">

    </div>

    <!-- Main content -->
    <section class="content">
        <div class="col-12">

            <div class="box">
                {{-- <div class="box-header with-border">
                    <h3 class="box-title"></h3>
                    @if (Request::is('admin/pages/static/delete'))
                        <a href="{{route('static.index')}}"
                           class="pull-left waves-effect waves-circle btn btn-circle btn-danger mb-5"
                           style="color: white;">
                            @if (App::getLocale() == 'ar')
                                <i class="fa fa-fw fa-arrow-right fa-lg"></i>
                            @else
                                <i class="fa fa-fw fa-arrow-left fa-lg"></i>
                            @endif
                        </a>

                    @else
                        <a href="{{route('static.add')}}"
                           class="pull-right waves-effect waves-circle btn btn-circle btn-secondary mb-5"><i
                                class=" fa fa-plus-circle fa-lg"></i></a>
                        <a href="{{route('static.delete')}}"
                           class="pull-left waves-effect waves-circle btn btn-circle btn-danger mb-5"
                           style="color: white;"><i class=" fa fa-trash-o fa-lg"></i></a>
                    @endif
                </div> --}}

                <div class="box">
                    <div class="box-header with-border">
                        <h3 class="box-title">{{ __('messages.static') }}</h3>
                        <br>
                        <br>
                        <div class="row">

                            @can('page_create')
                                <div class="col-md-3">
                                    <a href="{{ route('static.add') }}"
                                        class="text-center waves-effect  btn  btn-secondary mb-5">
                                        {{ __('messages.add-page') }}
                                    </a>
                                </div>
                            @endcan


                            <div class="col-md-6">
                                <div class="search-bx">
                                    <form method="get" action="{{ route('static.index') }}">
                                        <div class="input-group">
                                            <input type="search" name="search" class="form-control" placeholder="Search"
                                                aria-label="Search" value="{{ app('request')->input('search') }}"
                                                aria-describedby="button-addon2">
                                            &nbsp; &nbsp;
                                                    <select name="menu" data-placeholder="Type to search menus"
                                                        class="form-control custom-select">
                                                        <option
                                                            {{ app('request')->input('menu') == null ? 'selected' : '' }}
                                                            value=" ">
                                                            all
                                                        </option>
                                                        @if (!empty($menus))
                                                            @foreach ($menus as $name)
                                                                <option value=" {{ $name }} "
                                                                    {{ app('request')->input('menu') == $name ? 'selected' : '' }}>
                                                                    {{ $name }}</option>
                                                            @endforeach
                                                        @endif

                                                    </select>
                                                    @if ($errors->has('menu'))
                                                        <span class="help-block">
                                                            <strong
                                                                class="text-danger">{{ $errors->first('menu') }}</strong>
                                                        </span>
                                                    @endif
                                                <button class="btn" type="submit" id="button-addon3"><i
                                                        class="ti-search"></i></button>

                                        </div>



                                    </form>
                                </div>
                            </div>

                            @can('page_delete')
                                <div class="col-md-3">
                                    <button id="delete-box" class="text-center waves-effect  btn  btn-danger mb-5">
                                        {{ __('messages.deleted-all') }}
                                    </button>
                                </div>
                            @endcan


                        </div>


                    </div>
                </div>
                <!-- /.box-header -->
                <div class="box-body">
                    <div id="table_data">
                        <div class="table-responsive">
                            <table id="complex_header" class="table table-lg table-separated" style="width:100%">
                                <thead>
                                    <tr class="bg-dark">
                                        @can('page_delete')
                                            <th>
                                                <input style="position: relative; left: unset; opacity: 1;right: 0; "
                                                    type="checkbox" class="" id="select-all">
                                            </th>
                                        @endcan
                                        <th>#</th>
                                        <th>{{ __('messages.title_' . App::getLocale()) }}</th>
                                        <th>{{ __('messages.slug_' . App::getLocale()) }}</th>
                                        <th>{{ __('messages.tags_' . App::getLocale()) }}</th>
                                        <th>{{ __('messages.arrangment') }}</th>
                                        <th>{{ __('messages.type') }}</th>
                                        <th>{{ __('messages.status') }}</th>
                                        @can('page_update')
                                            <th>{{ __('messages.settings') }}</th>
                                        @endcan
                                    </tr>
                                </thead>
                                <tbody>
                                    @if (!empty($pages))
                                        @foreach ($pages as $page)
                                            <tr class="bg-table-gray changnametr">

                                                @can('page_update')
                                                    <td>
                                                        <input style="position: relative; left: unset; opacity: 1;right: 0; "
                                                            type="checkbox" name="ids[]" value="{{ $page->id }}"
                                                            class="dt-checkboxes" autocomplete="off">
                                                    </td>
                                                @endcan

                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $page->title }}</td>
                                                <td>{{ $page->slug }}</td>
                                                {{-- <td>{!! $page->body !!}</td> --}}
                                                <td>{{ $page->tags }}</td>
                                                <td>{{ $page->arrangment }}</td>
                                                <td>{{ $page->menu }}</td>
                                                <td>
                                                    <div class="px-25 py-10 w-100">
                                                        @if ($page->enabel == 1)
                                                            <span
                                                                class="badge badge-success">{{ __('messages.isActive') }}</span>
                                                        @else
                                                            <span
                                                                class="badge badge-danger">{{ __('messages.inActive') }}</span>
                                                        @endif
                                                    </div>
                                                </td>
                                                @can('page_update')
                                                    <td>
                                                        <div class="btn-group mb-5">
                                                            <button type="button"
                                                                class="waves-effect waves-light btn btn-secondary dropdown-toggle"
                                                                data-toggle="dropdown" aria-expanded="false">

                                                            </button>
                                                            <div class="dropdown-menu" style="">
                                                                <a class="dropdown-item"
                                                                    href="{{ route('static.updated', $page->id) }}">{{ __('messages.edit') }}</a>

                                                                @can('page_updated_status')
                                                                    <a class="dropdown-item"
                                                                        href="{{ route('static.toggle.status', $page->id) }}">
                                                                        @if ($page->enable == 1)
                                                                            {{ __('messages.changeToInActive') }}
                                                                        @else
                                                                            {{ __('messages.changeToActive') }}
                                                                        @endif
                                                                    </a>
                                                                @endcan


                                                            </div>
                                                        </div>
                                                    </td>
                                                @endcan

                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                        </div>
                        <div class="dataTables_paginate paging_simple_numbers" id="example_paginate">
                            {{ $pages->links() }}
                        </div>
                    </div>
                </div>
                <!-- /.box-body -->
            </div>
            <!-- /.box -->
        </div>
    </section>
@endsection

@section('js')
    <script>
        $('#select-all').click(function(event) {
            if (this.checked) {
                // Iterate each checkbox
                $(':checkbox').each(function() {
                    this.checked = true;
                });
            } else {
                $(':checkbox').each(function() {
                    this.checked = false;
                });
            }
        });

        // $('.delete-box').on('click', function(e) {

        // var idsArr = [];
        // $(".checkbox:checked").each(function() {
        //     idsArr.push($(this).attr('data-id'));
        // });

        // if(idsArr.length <=0)
        // {
        //     alert("Please select atleast one record to delete.");
        // }  else {

        //     if(confirm("Are you sure, you want to delete the selected categories?")){

        //         var strIds = idsArr.join(",");

        //         $.ajax({
        //             url: "{{ route('static.multiple-delete') }}",
        //             type: 'DELETE',
        //             _token: "{{ csrf_token() }}",
        //             data: 'ids='+strIds,
        //             success: function (data) {
        //                 if (data['status']==true) {
        //                     $(".checkbox:checked").each(function() {
        //                         $(this).parents("tr").remove();
        //                     });
        //                     alert(data['message']);
        //                 } else {
        //                     alert('Whoops Something went wrong!!');
        //                 }
        //             },
        //             error: function (data) {
        //                 alert(data.responseText);
        //             }
        //         });


        //     }
        // }
        // });
        $('#delete-box').click(function() {
            var id = [];
            $('.dt-checkboxes:checked').each(function() {
                id.push($(this).val());
            });
            if (id.length > 0) {
                console.log(id);
                swal.fire({
                    title: `{{ __('Are you sure to delete') }} ${id.length}  {{ __('pages') }}`,
                    text: "{{ __('You will not be able to recover this!') }}",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "{{ __('Yes, delete it!') }}",
                    cancelButtonText: "{{ __('Cancel') }}",
                    closeOnConfirm: false
                }).then(function(result) {
                    if (result.isConfirmed) {
                        // ajax to remove here
                        $.ajax({
                            url: "{{ route('static.multiple-delete') }}",
                            method: "post",
                            data: {
                                id: id,
                                _token: '{{ csrf_token() }}',
                            },
                        }).done(function(data) {
                            $('.bg-warning').remove().countSeletToDelete();
                            return swal.fire({
                                title: `{{ __('The deletion was completed successfully') }}`,
                                text: "{{ __('not related to products') }}",
                                type: "success",
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "{{ __('Okey') }}",
                                confirmOnConfirm: false
                            });
                        }).then(function() {
                            console.log('aaa');
                            window.location.replace("{{ route('static.index') }}");
                        }).catch(function(error) {
                            // Handle AJAX errors here
                            console.error(error);
                        });
                    }
                });
            } else {
                swal.fire({
                    title: `{{ __('please select one.') }}`,
                    confirmButtonText: "{{ __('Okey') }}",
                });
            }
        });
    </script>
@endsection
