@extends('admin.layout.index')
@section('title')
    {{ __('messages.static_page') }}
@endsection
@section('css')
    <style>
        .center-test {
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;

        }

        .form-input-test {
            width: 350px;
            padding: 20px;
            background: #fff;
            box-shadow: -3px -3px 7px rgba(94, 104, 121, 0.377),
                3px 3px 7px rgba(94, 104, 121, 0.377);
            margin-bottom: 50px;
            margin-top: 50px;
        }

        .form-input-test img {
            width: 100%;
            margin-bottom: 30px;
            position: relative;
            max-height: 100%;
            border: 4px solid #fff;

        }

        .form-input-test input {
            display: none;
        }

        .form-input-test label {
            display: block;
            width: 45%;
            height: 45px;
            line-height: 50px;
            text-align: center;
            background: #1172c2;
            color: #fff;
            font-size: 15px;
            font-family: "Open Sans", sans-serif;
            text-transform: Uppercase;
            font-weight: 600;
            border-radius: 5px;
            cursor: pointer;
            margin: auto;
        }
    </style>
@endsection
@section('content')
    <div class="content-header">

    </div>
    <div class="content">
        <div class="col-12">
            <div class="box box-default">
                <div class="box-header with-border">
                    <h4 class="box-title">{{ __('messages.add-page') }}</h4>
                </div>
                <form method="post" action="{{ route('static.add') }}" enctype="multipart/form-data">
                    <!-- /.box-header -->
                    <div class="box-body">
                        <!-- Nav tabs -->
                        <ul class="nav nav-tabs nav-fill" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link {{ session('back') == null ? 'active' : '' }} {{ session('back') != null && session('back')['open'] == 1 ? 'active' : '' }} "
                                    data-toggle="tab" href="#arabic" role="tab">
                                    <span>
                                        <i class="flag-icon flag-icon-eg mr-1"></i></span>
                                    <span class="hidden-xs-down ml-15">{{ __('messages.lang-ar') }}
                                    </span>
                                    @if (session('back') != null && isset(session('back')['error_ar']))
                                        <span style="color: orangered"><i class="fa fa-times mr-1"></i></span>
                                    @endif

                                </a>
                            </li>
                            <li class="nav-item"><a
                                    class="nav-link {{ session('back') != null && session('back')['open'] == 2 ? 'active' : '' }}"
                                    data-toggle="tab" href="#english" role="tab"><span><i
                                            class="flag-icon flag-icon-gb mr-1"></i></span> <span
                                        class="hidden-xs-down ml-15">{{ __('messages.lang-en') }}</span>
                                    @if (session('back') != null && isset(session('back')['error_en']))
                                        <span style="color: orangered"><i class="fa fa-times mr-1"></i></span>
                                    @endif
                                </a></li>
                        </ul>
                        <!-- Tab panes -->

                        <div class="tab-content tabcontent-border">
                            <div class="tab-pane {{ session('back') == null ? 'active' : '' }} {{ session('back') != null && session('back')['open'] == 1 ? 'active' : '' }} "
                                id="arabic" role="tabpanel">
                                <div class="p-15">

                                    <div class="row">
                                        <div class="col-md-12 text-center">
                                            <div class="center-test">
                                                <div class="form-input-test">
                                                    <div class="preview">
                                                        <img id="file-ip-1-preview" src="" style="display: none;">
                                                    </div>
                                                    <label for="file-ip-1"> {{ __('messages.photo') }} :<span
                                                            style="color: red"><i>*</i></span></label>
                                                    <input type="file" id="file-ip-1" name="photo"
                                                        onchange="showPreview(event);" accept="image/*">
                                                    <span id="file-error"
                                                        style="color: red; display:none;">{{ __('messages.imageMassageRequired') }}</span>

                                                    @if ($errors->has('photo'))
                                                        <span class="help-block">
                                                            <strong
                                                                class="text-danger">{{ $errors->first('photo') }}</strong>
                                                        </span>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="title_ar"> {{ __('messages.title_ar') }} : <span
                                                        style="color: red"><i>*</i></span> </label>
                                                <input type="text" class="form-control " id="title_ar" name="title_ar"
                                                    value="{{ old('title_ar') }}">
                                                @if ($errors->has('title_ar'))
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger">{{ $errors->first('title_ar') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="slug_ar">{{ __('messages.slug_ar') }} : <span
                                                        style="color: red"><i>*</i></span></label>
                                                <input type="text" name="slug_ar" id="slug_ar"
                                                    value="{{ old('slug_ar') }}" class="form-control">
                                                @if ($errors->has('slug_ar'))
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger">{{ $errors->first('slug_ar') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>


                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">

                                                <label for="wemailAddress2"> {{ __('messages.body_ar') }} : <span
                                                        style="color: red"><i>*</i></span> </label>
                                                <textarea id="body_ar" name="body_ar" rows="10" cols="80">
                                                    {!! old('body_ar') !!}
                                                </textarea>
                                                @if ($errors->has('body_ar'))
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger">{{ $errors->first('body_ar') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="title_ar"> {{ __('messages.menu') }} </label>
                                                <select name="menu" data-placeholder="Type to search menus"
                                                    class="form-control custom-select required select2">
                                                    @if (!empty($menus))
                                                        @foreach ($menus as $name)
                                                            <option value="{{ $name }}"
                                                                {{ old('menu') == $name ? 'selected' : '' }}>
                                                                {{ $name }}</option>
                                                        @endforeach
                                                    @endif

                                                </select>
                                                @if ($errors->has('menu'))
                                                    <span class="help-block">
                                                        <strong class="text-danger">{{ $errors->first('menu') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="title_ar"> {{ __('messages.notes') }} </label>
                                                <p class="text-danger">{{ __('messages.notesMunes') }}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="wemailAddress2"> {{ __('messages.tags_ar') }} : <span
                                                        style="color: red"><i>*</i></span> </label>
                                                <input type="text" class="form-control " name="tags_ar"
                                                    value="{{ old('tags_ar') }}">
                                                @if ($errors->has('tags_ar'))
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger">{{ $errors->first('tags_ar') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="status"> {{ __('messages.status') }} </label>
                                                <select name="enabel" data-placeholder="Type to search cities"
                                                    class="form-control custom-select required">
                                                    <option value="1" {{ old('enabel') == 1 ? 'selected' : '' }}>
                                                        {{ __('messages.isActive') }}</option>
                                                    <option value="0" {{ old('enabel') == 0 ? 'selected' : '' }}>
                                                        {{ __('messages.inActive') }}</option>
                                                </select>
                                                @if ($errors->has('enabel'))
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger">{{ $errors->first('enabel') }}</strong>
                                                    </span>
                                                @endif

                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="arrangment">{{ __('messages.arrangment') }} : </label>
                                                <input type="number" name="arrangment" id="arrangment"
                                                    value="{{ old('arrangment') != null ? old('arrangment') : 1 }}"
                                                    class="form-control" id="webUrl3">
                                                @if ($errors->has('arrangment'))
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger">{{ $errors->first('arrangment') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane {{ session('back') != null && session('back')['open'] == 2 ? 'active' : '' }}"
                                id="english" role="tabpanel">
                                <div class="p-15">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="title_en"> {{ __('messages.title_en') }} : <span
                                                        style="color: red"><i>*</i></span> </label>
                                                <input type="text" class="form-control" id="title_en"
                                                    name="title_en" value="{{ old('title_en') }}" id="title_en">
                                                @if ($errors->has('title_en'))
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger">{{ $errors->first('title_en') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="slug_en">{{ __('messages.slug_en') }} : <span
                                                        style="color: red"><i>*</i></span></label>
                                                <input type="text" name="slug_en" id="slug_en"
                                                    value="{{ old('slug_en') }}" class="form-control" id="webUrl3">
                                                @if ($errors->has('slug_en'))
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger">{{ $errors->first('slug_en') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="wemailAddress2"> {{ __('messages.body_en') }} : <span
                                                        style="color: red"><i>*</i></span> </label>
                                                <textarea id="body_en" name="body_en" rows="10" cols="80">
                                                    {!! old('body_en') !!}
                                                </textarea>
                                                @if ($errors->has('body_en'))
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger">{{ $errors->first('body_en') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>


                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="wemailAddress2"> {{ __('messages.tags_en') }} : <span
                                                        style="color: red"><i>*</i></span> </label>
                                                <input type="text" class="form-control " name="tags_en"
                                                    value="{{ old('tags_en') }}">
                                                @if ($errors->has('tags_en'))
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger">{{ $errors->first('tags_en') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>

                    </div>
                    <input type="hidden" value="{{ csrf_token() }}" name="_token">
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <button type="submit" class="btn btn-rounded btn-primary btn-outline">
                            <i class="ti-save-alt"></i> Save
                        </button>
                    </div>
                </form>
            </div>
            <!-- /.box -->
        </div>
    </div>

@endsection
@section('js')
    <script>
        $(function() {
            "use strict";

            // Replace the <textarea id="editor1"> with a CKEditor
            // instance, using default configuration.
            CKEDITOR.replace('body_ar', {
                removePlugins: 'scayt,wsc',
                disableNativeSpellChecker: true
            })
            CKEDITOR.replace('body_en', {
                removePlugins: 'scayt,wsc',
                disableNativeSpellChecker: true
            })
            CKEDITOR.replace('body_fr', {
                removePlugins: 'scayt,wsc',
                disableNativeSpellChecker: true
            })
            //bootstrap WYSIHTML5 - text editor
            $('.textarea').wysihtml5();

        });

        $("#title_ar").on('input', function() {
            var titleValue = $(this).val();
            var slugValue = titleValue.toLowerCase().replace(/\s+/g, '-');
            $("#slug_ar").val(slugValue);
        });

        $("#title_en").on('input', function() {
            var titleValue = $(this).val();
            var slugValue = titleValue.toLowerCase().replace(/\s+/g, '-');
            $("#slug_en").val(slugValue);
        });
        $("#title_fr").on('input', function() {
            var titleValue = $(this).val();
            var slugValue = titleValue.toLowerCase().replace(/\s+/g, '-');
            $("#slug_fr").val(slugValue);
        });

        $(document).ready(function() {
            $('.select_2').select2();
        });

        function showPreview(event) {
            //alert('showPreview');
            if (event.target.files.length > 0) {

                let file = event.target.files[0];
                let img = new Image();
                let src = URL.createObjectURL(file);
                img.onload = function() {
                    console.log(img.height, img.width);
                    let ratio = img.width / img.height;
                    let prefered = Math.abs(ratio - 16 / 9) > 0.01;
                    if (img.width > 200 && img.height > 200 && prefered) {
                        let preview = document.getElementById("file-ip-1-preview");
                        preview.src = src;
                        preview.style.display = "block";
                    } else {
                        swal.fire({
                            title: "{{ __('The image width or height is less than 200px') }}",
                            type: "info",
                            confirmButtonColor: "#009EDB",
                            closeOnConfirm: false
                        })
                        event.target.value = "";
                        document.getElementById("file-ip-1-preview").style.display = "none";
                    }
                };

                img.src = src;
            }
        }

        document.querySelector('form').addEventListener('submit', function(e) {
            let fileInput = document.getElementById("file-ip-1");
            if (fileInput.files.length === 0) {
                e.preventDefault();
                document.getElementById("file-error").style.display = "block";
            }
        });
    </script>
@endsection
