@extends('admin.layout.index')
@section('title')
    chose cities
@endsection
@section('css')

    <style>
        #no_more_data_message_history,
        #no_more_data_message_home,
        #ajax-load-history,
        #ajax-load-home {
            text-align: center;
            position: relative
        }

        #no_more_data_message_history::before,
        #no_more_data_message_home::before {
            content: '';
            position: absolute;
            left: 30%;
            top: 50%;
            transform: translateY(-50%);
            height: 2px;
            width: 3%;
            background-color: #c00319
        }

        #no_more_data_message_history::after,
        #no_more_data_message_home::after {
            content: '';
            position: absolute;
            right: 30%;
            top: 50%;
            transform: translateY(-50%);
            height: 2px;
            width: 3%;
            background-color: #c00319
        }

        #home-forms-scroll-container,


    </style>
@endsection
@section('content')

    <!-- Content Header (Page header) -->

    <div class="content-header">

    </div>

    <!-- Main content -->
    <section class="content">
        <div id="model_add_or_updated" class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="myLargeModalLabel">add or updated city</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                    </div>
                    <div class="modal-body">
                        <ul class="nav nav-tabs nav-fill" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active"
                                   data-toggle="tab" href="#add" role="tab">
                                    <span>
                                        <i class="fa fa-plus mr-1"></i></span>
                                    <span class="hidden-xs-down ml-15">Add New
                                    </span>
                                </a>
                            </li>
                            <li class="nav-item"><a
                                    class="nav-link "
                                    data-toggle="tab" href="#updated" role="tab"><span><i
                                            class="fa fa-history mr-1"></i></span> <span
                                        class="hidden-xs-down ml-15">updated old</span>
                                </a></li>
                        </ul>
                        <div class="tab-content tabcontent-border">
                            <div class="tab-pane active " id="add" role="tabpanel">
                                <div class="p-15">
                                    <form id="add_new_oclick">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="name_ar"> city name ar: <span
                                                        class="danger">*</span> </label>
                                                <input type="text" class="form-control " id="name_ar" name="name_ar"
                                                       value="">
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger name_ar-error"></strong>
                                                    </span>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="arrangment"> city name en : </label>
                                                <input type="text" id="name_en" class="form-control" name="name_en"
                                                      value="" >
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger name_en-error"></strong>
                                                    </span>
                                            </div>
                                        </div>
                                        <input type="hidden" name="country_id" id="country_id_model_add" value="">
                                        <div class="col-md-12 text-center">
                                            <button onclick="add()" type="button" class="btn btn btn-primary text-center center" >Save</button>
                                        </div>
                                    </div>
                                    </form>
                                </div>
                            </div>
                            <div class="tab-pane" id="updated" role="tabpanel">
                                <div class="p-15">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="mySelect"> Chose Cities : <span
                                                        class="danger">*</span> </label>
                                                <select id="mySelect" class="form-control custom-select" name="mySelect">
                                                </select>
                                                    <span class="help-block">
                                                        <strong
                                                            class="text-danger city_id-error"></strong>
                                                    </span>
                                            </div>

                                            <input type="hidden" name="country_id" id="country_id_model_add" value="">
                                            <div class="col-md-12 text-center">
                                                <button onclick="updated()" type="button" class="btn btn btn-primary text-center center" >Save</button>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger text-left" data-dismiss="modal">Close</button>
                    </div>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
        <div class="col-12">

            <div class="box">


                <div class="box">
                    <div class="box-header with-border">
                        <h3 class="box-title"></h3>
                        <br>
                        <br>
                        <div class="row">
                            <div class="col-md-3">
                                <button  onclick="addorupdatedModel()"
                                   class="text-center waves-effect  btn  btn-secondary mb-5">
                                    merage
                                </button>
                            </div>
                            <div class="col-md-9">
                                    <div class="row">
                                        <div class="col-3">
                                            <input type="search" id="search_name" name="search" class="form-control" placeholder="Search"
                                                   aria-label="Search" value=""
                                                   aria-describedby="button-addon2">
                                        </div>
                                        <div class="col-3">
                                            <select name="country" id="country_id" data-placeholder="Type to search menus"
                                                    class="form-control custom-select">
                                                @if (!empty($country))
                                                    @foreach ($country as $cou)
                                                        <option value=" {{ $cou->id }} "
                                                            {{ app('request')->input('country') == $cou->id ? 'selected' : '' }}>
                                                            {{ $cou->name_ar .' | '.$cou->name_en}}</option>
                                                    @endforeach
                                                @endif

                                            </select>
                                        </div>
                                        <div class="col-3">
                                            <button onclick="getSearch()" class="btn" type="button" id="button-addon3"><i
                                                    class="ti-search"></i></button>

                                        </div>

                                    </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.box-header -->
                <div class="box-body" id="get_data">

                </div>
                <!-- /.box-body -->
            </div>
            <!-- /.box -->
        </div>
    </section>
@endsection

@section('js')
    <script>

        $(document).ready(function () {
            $('.custom-select').select2();
        });

    </script>
    <script>
        let pageHistory =1;
        var scroll_again_history = 1;
        $('#select-all').click(function (event) {
            if (this.checked) {
                // Iterate each checkbox
                $(':checkbox').each(function () {
                    this.checked = true;
                });
            } else {
                $(':checkbox').each(function () {
                    this.checked = false;
                });
            }
        });

        function getSearch()
        {
            let search ='&name=' + $('#search_name').val();
            let country ='&country='+ $('#country_id').val();
            pageHistory =1;
            let params = search + country;
            loadMoreData(pageHistory,params,'replacement');
        }



        function loadMoreData(page,params,AppendReplace) {
            $.ajax({
                url: '{{ route('cities.search') }}?page=' +
                    page + params,
                type: "get",
                beforeSend: function() {
                    $('#ajax-load-history').show();
                }
            }).done(function(data) {
                if (!data) {
                    $('#no_more_data_message_history').show()
                    $('#ajax-load-history').hide();
                    if (AppendReplace == 'replacement') {
                        $("#get_data").html('');
                        scroll_again_history = 1;
                    }
                    scroll_again_history = 0;
                    return;
                }
                $('#ajax-load-history').hide();
                if (AppendReplace == 'append') {
                    $("#get_data").append(data);
                } else {
                    $("#get_data").html(data);
                    scroll_again_history = 1;
                }

            }).fail(function(jqXHR, ajaxOptions, thrownError) {
                    alert('server not responding...');

            });
        }

        function addorupdatedModel(){
            var id = [];
            $('.dt-checkboxes:checked').each(function () {
                id.push($(this).val());
            });
            if(id.length > 0)
            {
                let country = $('#country_id_model_add').val();
                $.ajax({
                    url: '{{route('cities.getCitiesById',' ')}}'+country,
                    method: 'GET',
                    success: function (response) {
                        $('#mySelect').empty();
                        $.each(response.data, function (key, option) {
                            $('#mySelect').append('<option value="' + option.id + '">' + option.name_ar  + '||' + option.name_en+'</option>');
                        });
                    },
                    error: function (error) {
                        console.log('Error:', error);
                    }
                });
                $('#model_add_or_updated').modal('show');

            }else{
                swal.fire({
                    title: `please select one.`,
                    confirmButtonText: "Okey",
                });
            }
        }
        function add() {
            var id = [];
            $('.dt-checkboxes:checked').each(function () {
                id.push($(this).val());
            });
            if(id.length > 0)
            {
                let data = new FormData();
                let name_ar = $('#name_ar').val();
                let name_en = $('#name_en').val();
                let country = $('#country_id_model_add').val();
                data.append('ids',id);
                data.append('name_ar',name_ar);
                data.append('name_en',name_en);
                data.append('_token','{{ csrf_token()}}');
                data.append('country_id',country);
                $.ajax({
                    url: '{{ route('cities.add') }}',
                    method: "post",
                    data:data,
                    processData: false,
                    contentType: false,
                    beforeSend: function() {
                    $('#ajax-load-history').show();
                    },success:function (data){
                        if(data.status == 200)
                        {
                                swal.fire({
                                    title: `add success.`,
                                    icon: "success",
                                });

                            $('#model_add_or_updated').modal('hide');
                               getSearch();

                        }
                        else if(data.status == 201)
                        {
                            $.each(data.data,function (key ,vale){
                                $('.'+key+'-error').html(vale);
                            });
                        }
                    },error:function (data) {

                    }

                })
            }else{
                swal.fire({
                    title: `please select one.`,
                    confirmButtonText: "Okey",
                });
            }
        }

        function updated() {
            var id = [];
            $('.dt-checkboxes:checked').each(function () {
                id.push($(this).val());
            });
            if(id.length > 0)
            {
                let city_id =$('#mySelect').val();
                let data = new FormData();
                data.append('ids',id);
                data.append('city_id',city_id);
                data.append('_token','{{ csrf_token()}}');
                $.ajax({
                    url: '{{ route('cities.updated') }}',
                    method: "post",
                    data:data,
                    processData: false,
                    contentType: false,
                    beforeSend: function() {
                        $('#ajax-load-history').show();
                    },success:function (data){
                        if(data.status == 200)
                        {
                            swal.fire({
                                title: `update success.`,
                                icon: "success",
                            });

                            $('#model_add_or_updated').modal('hide');
                            getSearch();

                        }
                        else if(data.status == 201)
                        {
                            $.each(data.data,function (key ,vale){
                                $('.'+key+'-error').html(vale);
                            });
                        }
                    },error:function (data) {

                    }

                })
            }else{
                swal.fire({
                    title: `please select one.`,
                    confirmButtonText: "Okey",
                });
            }
        }
    </script>
@endsection
