<?php

namespace App\Sys\ServicesProvidor\MR;

// for company => multireisen
use GuzzleHttp\Client;

trait MR
{
    public function MR($method = "get", $token = null, $endpoint, $parameter = null)
    {
        $client = new Client();
        $point = env('MULTIREISEN_Url') . '/' . $endpoint;
        $options = [
            'headers' => [
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
                'Authorization' => 'Basic ' . env('MULTIREISEN_Authorization')
            ],
        ];
        if ($token != null)
        {
            $options['headers']['AccessToken']=$token;
            $options['headers']['Version']='v1';

        }
        if (in_array(strtoupper($method), ['POST', 'PUT'])) {
            $options['json'] = $parameter;
        } else {
            $options['query'] = $parameter;
        }
        $response = $client->request($method, $point, $options);
        return json_decode($response->getBody(), true);


    }
}
