<?php

namespace App\Sys\Services\staticData\cities;

use App\Sys\Repository\staticData\cities\CitiesRepo;
use App\Sys\Repository\staticData\cities\CityCodeRepo;
use App\Sys\Services;
use Illuminate\Validation\Rule;
use Validator;

class CitiesNamedServices extends Services
{

    private $citiesNamed;
    private $cityCode;

    public function __construct()
    {
        $this->citiesNamed = new CitiesRepo();
        $this->cityCode  = new CityCodeRepo();
    }

    public function gets()
    {
        return $this->citiesNamed->gets();
    }

    public function search($name,$country)
    {
        return $this->citiesNamed->search($name,$country);
    }
    public function searchForApi($name,$country)
    {
        return $this->citiesNamed->searchForApi($name,$country);
    }



    public function add($data)
    {

        $country_id = $data['country_id'];
        // rules
        $rules = [
            'name_ar' => ['required',
                Rule::unique('cities_named')->where(function ($query) use ($country_id) {
                    return $query->where('country_id', $country_id);
                }),
            ],
            'name_en' => ['required',
                Rule::unique('cities_named')->where(function ($query) use ($country_id) {
                    return $query->where('country_id', $country_id);
                }),
            ],
            'country_id'=>'required',
            'ids'=>'required'
        ];
        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());
            return false;
        }

        if($this->citiesNamed->add($data))
            return true;


        $this->setError(['Have Errors']);
        return false;

    }

    public function getCities($country_id)
    {
        return $this->citiesNamed->getCitiesNamed($country_id);
    }

    public function updated($data)
    {
        $rules = [
            'city_id'=>'required',
            'ids'=>'required'
        ];
        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());
            return false;
        }
        if($this->citiesNamed->updated($data))
            return true;


        $this->setError(['Have Errors']);
        return false;

    }

    public function getWithCityCode($id)
    {
        return $this->citiesNamed->withCode($id);
    }

    public function getCodeCity($id)
    {
        return $this->cityCode->getCodeByCityId($id);
    }
}
