<?php

namespace App\sys\Services\Hotel;

use App\Models\Reservation;
use App\Models\Result;
use App\sys\Api\TBOServices;
use App\Sys\Services;
use Illuminate\Support\Arr;

class HotelServices extends Services
{
    private $tbo;


    public function __construct()
    {
        $this->tbo = new TBOServices();
    }

    public function getCountry()
    {
        return $this->tbo->getCountry();
    }

    public function city($code)
    {
        return $this->tbo->getCity($code);
    }

    public function getHotelCodeByCity($code, $is_detailed, $layout = 'normal')
    {
        return $this->tbo->HotelByCity($code, $is_detailed, $layout);
    }

    public function SearchRoom($data)
    {
        if($rooms =  $this->tbo->searchRooms($data))
            return $rooms;



        $this->setError($this->tbo->errors());
        return false;
    }

    public function SearchHotel($parmter)
    {
        //get hotel :)
        $id = request()->attributes->get('guest_id');
        $h = Result::where([['guest_id', $id],['type','hotel']])->first();
        if (!empty($h)) {
            $search = json_decode($h->search,true);
            $arr =  Arr::except(request()->all(), ['page', 'per_page','min','max','hotel_name','cases']);
            $a = array_diff_assoc($arr,$search);
            if(empty($a))
            {
                $hotelData = json_decode($h->properties);
                $count = count($hotelData);
                $page = request()->page;
                $perPage = request()->per_page;
                $totalPages = ceil($count / $perPage);
                $offset = ($page - 1) * $perPage;

                $rueslt['default-min'] = $count > 0 ?(float) collect($hotelData)->min('price') :0;
                $rueslt['default-max'] = $count > 0 ?(float) collect($hotelData)->max('price') :0;
                // check prices data
                if(((isset(request()->min) && request()->min !=null ) && (isset(request()->max) && request()->max !=null)) || (isset(request()->hotel_name) && request()->hotel_name != null))
                     $hotelData = $this->fillterPrices(request()->min,request()->max,$hotelData,request()->hotel_name);


                $rueslt['data'] =  array_slice((array)$hotelData, $offset, $perPage);
                $rueslt['count'] = count((array)$hotelData);
                $rueslt['search-min'] = isset(request()->min)&& request()->min !=null?(int) request()->min:$rueslt['default-min'];
                $rueslt['search-max'] = isset(request()->max)&& request()->max !=null?(int) request()->max:$rueslt['default-max'];
                return $rueslt;
            }
        }

        if($data = $this->resultshotel($parmter,$id)){
            return $data;
        }
        $this->setError($this->tbo->errors());
        return  false;
    }

    private function resultshotel($parmter,$id){
        if($hotelData = $this->tbo->searchHotel($parmter))
        {
            if($hotelData != null)
            {

                $count = count($hotelData);
                $page = request()->page;
                $perPage = request()->per_page;
                $totalPages = ceil($count / $perPage);
                $offset = ($page - 1) * $perPage;
                // add data
                $data =   $this->addHotel($hotelData,$id);
                $hotels = json_decode($data->properties);

                $rueslt['default-min'] = $count > 0 ?(float) collect($hotels)->min('price') :0;
                $rueslt['default-max'] = $count > 0 ?(float) collect($hotels)->max('price') :0;


                if(((isset(request()->min) && request()->min !=null ) && (isset(request()->max) && request()->max !=null)) ||(isset(request()->hotel_name) && request()->hotel_name != null))
                    $hotels = $this->fillterPrices(request()->min,request()->max,$hotels,request()->hotel_name);



                $rueslt['data'] = array_slice((array)$hotels, $offset, $perPage);
                $rueslt['count'] = count((array)$hotels);
                $rueslt['search-min'] = isset(request()->min)&& request()->min !=null?(int) request()->min:$rueslt['default-min'];
                $rueslt['search-max'] = isset(request()->max)&& request()->max !=null?(int) request()->max:$rueslt['default-max'];
                return $rueslt;
            }

        }
        $this->setError($this->tbo->errors());
        return  false;
    }

    public function fillterPrices($min,$max,$data,$name)
    {
        $mixR= $min != null ? $min :(float)collect($data)->min('price');
        $maxR= $min != null ? $max :(float) collect($data)->max('price');
        $filteredHotels = collect($data)->filter(function ($hotel) use ($mixR, $maxR,$name) {
            if($name != null)
                return $hotel->price >= $mixR && $hotel->price <= $maxR && stripos($hotel->hotel_name, $name) !== false;

            return $hotel->price >= $mixR && $hotel->price <= $maxR;
        });


        return json_decode($filteredHotels);
    }

    public function getPerBook($data,$company)
    {
        if($company == 'tbo')
        {

            if($hotel =  $this->tbo->prebook($data))
                return $hotel;


            $this->setError($this->tbo->errors());
            return  false;
        }
    }

    public function tboBooking($data)
    {

        if($this->tbo->booking($data))
        {
            // Save Data
            $hotel = $this->tbo->getData();
            $this->addReservation($hotel,'tbo',$data);
            $this->setData($hotel);
            return true;
        }
        $this->setError($this->tbo->errors());
        return  false;
    }

    public function cancel($data,$comp)
    {
        if($comp == "tbo")
        {
            if($this->tbo->cancel($data))
            {
                $hotel = $this->tbo->getData();
                $this->setData($hotel);
                $this->updatedReservation($hotel['ConfirmationNumber']);
                return true;
            }

            $this->setError($this->tbo->errors());
            return  false;
        }
    }

    public function addHotel($data,$id)
    {

        $h = Result::where([['guest_id', $id],['type','hotel']])->first();
        if(!empty($h)){
            $h->delete();
        }

        $addHotel = new Result();
        $addHotel->properties = $data;
        $addHotel->guest_id = $id;
        $addHotel->search = json_encode( Arr::except(request()->all(), ['page', 'per_page']));
        $addHotel->is_active = 1;
        $addHotel->type = 'hotel';
        $addHotel->save();
        return $addHotel;
    }


    public function bookingDetails($confirm,$co)
    {
            $data = [
                'ConfirmationNumber'=>$confirm,
            ];
            if($co == "tbo")
            {
                if($hotel = $this->tbo->bookingDetails($data))
                {
                    return $hotel;
                }
                $this->setError($this->tbo->errors());
                return  false;
            }


    }


    public function updatedReservation($data)
    {
        $rese = Reservation::where('confirmation_number',$data)->first();
        $rese->status = 'cancel';
        return $rese->save();
    }

    public function addReservation($data,$com,$hotel)
    {
        if($data['Status']['Code']== 200)
        {
            $room = $hotel->room_name ?? $hotel->rome_name ?? null;
            $rese = new Reservation();
            $rese->guest_id = request()->attributes->get('guest_id');
            $rese->company = $com;
            $rese->client_referenceId = $data['ClientReferenceId'];
            $rese->confirmation_number = $data['ConfirmationNumber'];
            $rese->total_fare = $hotel->TotalFare;
            $rese->phone_number = $hotel->PhoneNumber;
            $rese->payment = $hotel->PaymentMode;
            $rese->check_in = $hotel->check_in;
            $rese->check_out = $hotel->check_out;
            $rese->hotel_name = $hotel->hotel_name;
            $rese->user_id = Auth()->guard('api')->check() ? Auth()->guard('api')->user()->id:null;
            $rese->rome_name = $room;
            return $rese->save();
        }
        return  false;
    }

    public function getHotelDetails($data)
    {
        $data['Language'] =  isset($data['Language'])&& $data['Language']!=null ? $data['Language']:'EN';
        if($hotel = $this->tbo->hotelDetials($data))
            return $hotel;

        $this->setError($this->tbo->errors());
        return  false;
    }
}
