<?php

namespace App\Sys\Repository\staticData\cities;

use App\Models\hotel_city;

class hotelCityRepo
{

    private $citiy;


    public function __construct()
    {
        $this->citiy = new hotel_city();
    }

    public function search($name,$country,$com)
    {
        return $this->citiy->when($name, function ($q) use ($name) {
            $q->where('name','like' ,"%$name%");
        })->where([
            ['country_id',$country]
            ,['status',0],
            ['company',$com]
        ])->orderBy('updated_at', 'desc')->paginate(20);
    }

    public function getById($id)
    {
        return $this->citiy->find($id);
    }
}
