<?php

namespace App\Sys\Repository;

use App\Models\Airports;

class airportsRepo
{
    private $airPort;
    public function __construct(){
        $this->airPort = new Airports();
    }

    public function search($code)
    {
        return $this->airPort->with('getCountry','getCity')
            ->where(function ($query) use ($code) {
                $query->where('code','like',"%$code%")
                    ->orWhere('city_code','like',"%$code%")
                    ->orWhere('name_en','like',"%$code%");
            })->orWhere(function ($query) use ($code) {
                $query->whereHas('getCountry', function ($query) use ($code) {
                    $query->where('name_en','like',"$code%")
                        ->orWhere('name_ar','like',"$code%");
                });
            })->orWhere(function ($query) use ($code){
                $query->whereHas('getCity', function ($query) use ($code) {
                    $query->where('name_en','like',"$code%")
                        ->orWhere('name_ar','like',"$code%");
                });
            })->orderBy('code')->get();
    }
}
