<?php

namespace App\Sys\Api;

use App\Models\Sessions;
use App\Models\TestCase;
use App\Sys\Services;
use App\Sys\ServicesProvidor\TBO\TBO;

class TBOAirServices extends Services
{
    use TBO;

    public function Auth()
    {
        // 'UserName'=>'Onttest',
        // 'Password'=>'Ot@131020',
        $paramter = [

            'UserName' => env('TBO_STAGING_API_USERNAME_Air'),
            //'UserName' =>'Onttest',
            'Password' => env('TBO_STAGING_API_PASSWORD_Air'),
           // 'Password' => 'Ot@131020',
            "BookingMode" => "API",
            "IPAddress" => ""
        ];

        $result = $this->TBO('post', 'Authenticate/ValidateAgency', $paramter, 'air');
        if ($result['IsSuccess'] == true)
            return $result;


        $errors =  $result['Errors'][0]['UserMessage'] ?? "Not Authenticated from TBo"  ;
        $this->setError($errors);
        return false;

    }

    public function preparedSearchData($data)
    {
        return $data;
    }
    public function search($data)
    {
        $result = $this->TBO('post', 'Search/Search', $data, 'air');
        $id = request()->attributes->get('guest_id');
        $segments= $data['Segment'];
        $origin = '';
        $preferredAirline ='';
        foreach ($segments as $segment) {
            if (isset($segment['Origin']) && isset($segment['Destination'])) {
                $origin .='( '.$segment['Origin'].' - '.$segment['Destination'].' ) - ';
            }
            if (isset($segment['PreferredAirlines']) && !empty($segment['PreferredAirlines'])) {
                $preferredAirline .= '( '.$segment['PreferredAirlines'][0].' ) - ';
            }
        }

        /**
        $name =$origin.' - ( '.$preferredAirline.' ) '.' AdultCount: '.$data['AdultCount'].' - ChildCount '.$data['ChildCount'].' - InfantCount ' .$data['InfantCount'];
        $case = TestCase::where('guest_id',$id)->first();
        if(empty($case))
        {
            $new = new TestCase();
            $new->guest_id = $id;
            $new->name =$name;
            $new->cases =isset($data['cases'])?$data['cases']:0;
            $new->search_response =json_encode($data);
            $new->search_result =json_encode($result);
            $new->save();
        }else{
            $case->name =$name;
            $case->search_response =json_encode($data);
            $case->search_result =json_encode($result);
            $case->save();
        }
         * **/

        if ($result['IsSuccess'] == true)
             return $result;



        $errors =  $result['Errors'][0]['UserMessage'] ?? "Have Errors";
        //$errors =  $result ;
        $this->setError($errors);
        return false;
    }

    public function upSell($data)
    {
       $result = $this->TBO('post', 'Detail/AddOnFares', $data, 'air');
        if ($result['ErrorMessage'] == null)
            return $result['FlightResults'];


        return false;
    }

    public function fareRule($data)
    {
        $result = $this->TBO('post', 'Detail/FareRule', $data, 'air');
        if ($result['IsSuccess'] == true)
            return $result['FareRules'];



        $errors = ['errors' => $result['Errors'][0]['UserMessage'] ?? "Have Errors" ] ;
        $this->setError($errors);
        return false;
    }

    public function fareQuote($data)
    {
        $result = $this->TBO('post', 'Detail/FareQuote', $data, 'air');
        if ($result['IsSuccess'] == true)
            return $result;




        $errors = ['errors' => $result['Errors'][0]['UserMessage'] ?? "Have Errors" ] ;
        $this->setError($errors);
        return false;
    }

    public function getSSR($data)
    {
        $result = $this->TBO('post', 'Detail/GetSSR', $data, 'air');
        if ($result['IsSuccess'] == true)
            return $result;


        $errors = ['errors' => $result['Errors'][0]['UserMessage'] ?? "Have Errors" ] ;
        $this->setError($errors);
        return false;
    }

   public function BookingNoncLcc($data)
   {
       $result = $this->TBO('post', 'Booking/Book', $data, 'air');
       $id = request()->attributes->get('guest_id');
       $case = TestCase::where('guest_id',$id)->first();
       $case->booking_response =json_encode($data);
       $case->booking_result =json_encode($result);
       $case->save();
       if($result['IsSuccess'] == true)
       {
           $guest = Sessions::find($id);
           $guest->resultId = $data->ResultId;
           $guest->save();
           return $result;
       }



       $errors = $result['Errors'][0]['UserMessage'] ?? "Have Errors";
       $this->setError($errors);
       return false;
   }

   public function Ticket($data)
   {
       $result = $this->TBO('post', 'Booking/Ticket', $data, 'air');
       $id = request()->attributes->get('guest_id');
       $case = TestCase::where('guest_id',$id)->first();
       $case->ticket_response =json_encode($data);
       $case->ticket_result =json_encode($result);
       $case->done =$result['IsSuccess'] == true &&  $case->done == 0?1:$case->done;
       $case->save();

         if($result['IsSuccess'] == true || ($result['PNR'] != "-" && $result['PNR'] != null))
            return $result;


       $errors = $result['Errors'][0]['UserMessage'] ?? "Have Errors";
       $this->setError($errors);
       return false;
   }

   public function getDitals($data)
   {
       $result = $this->TBO('post', 'Booking/GetBookingDetails', $data, 'air');
       /*
       $id = request()->attributes->get('guest_id');
       $case = TestCase::where('guest_id',$id)->first();
       if(!empty($case))
       {
           $case->gobooking_response =json_encode($data);
           $case->gobooking_result =json_encode($result);
           $case->save();
       }
        */
       if($result['IsSuccess'] == true)
       {
           $data['Itinerary'] =$result['Itinerary'];
           $data['ShowFailedReason'] =$result['ShowFailedReason'];
           $data['isPassportRequiredAtTicket'] =$result['isPassportRequiredAtTicket'];
           $data['OnlineRefund'] =$result['OnlineRefund'];
           $data['VoidApplicable'] =$result['VoidApplicable'];
           return $data;
       }
       if($result['Errors'] != null)
       {
           $errors =  is_array($result['Errors']) ? $result['Errors'][0]['UserMessage'] : $result['Errors'];
           $this->setError($errors);
           return  false;
       }

       $this->setError("Not Found This Ticket Details  :( ");
       return  false;

   }
}
