<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class TBOPreBookResources extends JsonResource
{

    protected $companyName;

    public function __construct($resource, $companyName)
    {
        parent::__construct($resource);
        $this->companyName = $companyName;
    }
    public function toArray($request)
    {
        return [
            'company_name' => $this->companyName,
            'hotel_code' => $this['HotelCode'],
            'currency' => $this['Currency'],
            'name_room' => $this['Rooms'][0]['Name'],
            'bookingCode' => $this['Rooms'][0]['BookingCode'],
            'inclusion' => $this['Rooms'][0]['Inclusion'],
            'dayRates' => $this['Rooms'][0]['DayRates'],
            'totalFare' => $this['Rooms'][0]['TotalFare'],
            'totalTax' => $this['Rooms'][0]['TotalTax'],
            'cancelPolicies' => $this['Rooms'][0]['CancelPolicies'],
            'mealType' => $this['Rooms'][0]['MealType'],
            'isRefundable' => $this['Rooms'][0]['IsRefundable'],
            'withTransfers' => $this['Rooms'][0]['WithTransfers'],
            'amenities' => $this['Rooms'][0]['Amenities'],
            'rateConditions' => $this['RateConditions'],
            'required_fields'=>[
                'company'=>$this->companyName,
                'bookingCode'=>$this['Rooms'][0]['BookingCode'],
                "BookingType"=>"Voucher",
                "PaymentMode"=>"Limit",
                "TotalFare"=>$this['Rooms'][0]['TotalFare'],
                "ClientReferenceId"=> "20230706#01",
                "BookingReferenceId"=> "20230706#Gulf1"
            ],
            'all_data'=> $this->resource
        ];
    }
}
