<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class TBOHotelDetailsResource extends JsonResource
{

    protected $companyName;
    public function __construct($resource, $companyName)
    {
        parent::__construct($resource);
        $this->companyName = $companyName;
    }

    public function toArray(Request $request): array
    {
        $map = $this['Map'] ?? null;

        // استخراج القيم إذا كانت الـ Map موجودة
        $coordinates = $map ? explode('|', $map) : [null, null];
        $latitude = $coordinates[0];
        $longitude = $coordinates[1];
        return [
            'company_name' => $this->companyName,
            'hotel_code' => $this['HotelCode'] ?? null,
            'hotel_name' => $this['HotelName'] ?? null,
            'description' => $this['Description'] ?? null,
            'address' => $this['Address'] ?? null,
            'longitude' =>$longitude,
            'latitude' =>$latitude,
            'rating' => $this['HotelRating'] ?? null,
            'price' =>0, // Adjust if 'price' has a nested structure
            'currency' => '', // Adjust if 'currency' is nested
            'images' => $this['Images'],
            'facilities' => $this['HotelFacilities'],
            'all_data' => $this->resource,
        ];
    }
}
