<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MRRoomsResources extends JsonResource
{

    protected $companyName;

    public function __construct($resource, $companyName)
    {
        parent::__construct($resource);
        $this->companyName = $companyName;
    }
    public function toArray(Request $request): array
    {

        return [
            'company_name' => $this->companyName,
            'hotel_code' => '',
            'currency' => $this['price']['currency'],
            'name_room' => $this['name'],
            'bookingCode' => '',
            'inclusion' => $this['meals']['name'] ?? null,
            'dayRates' => '',
            'totalFare' => $this['price']['total'],
            'totalTax' => $this['price']['tax'],
            'required_fields'=>[
                'company'=>$this->companyName,
                'itemId' => $this['itemId'],
                'solutionId'=>$this['solutionId']
            ],
            'cancelPolicies' => $this['cxlPolicy']['conditions'],
            'mealType' => '',
            'isRefundable' => $this['cxlPolicy']['nonRefundable'],
            'withTransfers' => '',
            'all_data'=> $this->resource
        ];
    }

}
