<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class MRPreBookResources extends JsonResource
{

    protected $companyName;

    public function __construct($resource, $companyName)
    {
        parent::__construct($resource);
        $this->companyName = $companyName;
    }

    public function toArray($request)
    {
        return [
            'company_name' => $this->companyName,
            'hotel_code' => $this['properties']['hotelId'],
            'currency' => $this['rooms'][0]['price']['currency'],
            'name_room' => $this['rooms'][0]['name'],
            'bookingCode' => $this['itemId'],
            'inclusion' => $this['rooms'][0]['meal']['name'],
            'dayRates' => '',
            'totalFare' => $this['rooms'][0]['price']['total'],
            'totalTax' => $this['rooms'][0]['price']['tax'],
            'cancelPolicies' => $this['rooms'][0]['cxlPolicy'],
            'mealType' => '',
            'isRefundable' => $this['rooms'][0]['cxlPolicy']['nonRefundable'],
            'withTransfers' => '',
            'amenities' => '',
            'rateConditions' => '',
            'required_fields' => [
                'company' => $this->companyName,
                'itemId' => $this['itemId'],
                'solutionId' => $this['rooms'][0]['originalSolutionId'],
                "paymentId" => 9,
                'totalFare' => $this['rooms'][0]['price']['total'],
                'totalTax' => $this['rooms'][0]['price']['tax'],
            ],
            'all_data' => $this->resource
        ];
    }
}
