<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class MRHotelResources extends JsonResource
{

    protected $companyName;

    public function __construct($resource, $companyName)
    {
        parent::__construct($resource);
        $this->companyName = $companyName;
    }
    public function toArray($request)
    {

        $all =  $this->resource;
        $rooms = $this['rooms'];
        //$all['HotelInfo']['HotelPicture'] =$this['HotelInfo']['HotelPicture']??null;
        return [
            'company_name' => $this->companyName,
            'hotel_code' => $this['properties']['hotelId']??null ,
            'hotel_name' =>$this['properties']['name']??null,
            'photo' => $this['properties']['images'][0]['url']??null,
            'description' => '',
            'address' => $this['properties']['address']??null,
            'longitude' => $this['properties']['location']['geoCodes']['longitude']??null,
            'latitude' => $this['properties']['location']['geoCodes']['latitude']??null,
            'rating' => $this['properties']['category']['numeric']??null,
            'price' => $this->getPrices($rooms),
            //'currency' => $this['MinHotelPrice']['Currency']??null,
            'required_fields'=>[
                'company'=>$this->companyName,
                'itemId'=>$this['itemId']
            ],
            'all_data'=> $all
        ];
    }
    private  function getPrices($rooms)
    {
        $minPriceRoom = array_reduce($rooms, function ($carry, $item) {
            return ($carry === null || $item['price']['total'] < $carry['price']['total']) ? $item : $carry;
        });
        return $minPriceRoom['price']['total']??null;
    }
}
