<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class MRHotelDetailsResource extends JsonResource
{
    protected $companyName;
    public function __construct($resource, $companyName)
    {
        parent::__construct($resource);
        $this->companyName = $companyName;
    }
    public function toArray(Request $request): array
    {
        return [
            'company_name' => $this->companyName,
            'hotel_code' => $this['hotelId'] ?? null,
            'hotel_name' => $this['name'] ?? null,
            'description' => $this['description'] ?? null,
            'address' => $this['address'] ?? null,
            'longitude' => $this->extractGeoCode('longitude'),
            'latitude' => $this->extractGeoCode('latitude'),
            'rating' => $this['rating'] ?? null,
            'price' => $this['price']['amount'] ?? null,
            'currency' => $this['price']['currency'] ?? null,
            'images' => $this->extractImages(),
            'facilities' => $this['facilities'][0]['text'],
            'all_data' => $this->resource,
        ];
    }

    private function extractGeoCode($type)
    {
        return $this['location']['geoCodes'][$type] ?? null;
    }

    private function extractImages()
    {
        return collect($this['images']['all_data'] ?? [])->map(function ($image) {
            return $image['url'] ?? null;
        })->filter()->values();
    }


}
