<?php

namespace App\Http\Middleware;
use App\ApiResponse;
use Closure;
use Illuminate\Support\Facades\Auth;
use PHPOpenSourceSaver\JWTAuth\Facades\JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
class JwtMiddleware
{
   use ApiResponse;

    public function handle($request, Closure $next)
    {
        try {
            // Check if a token is present in the request
            $token = JWTAuth::parseToken()->authenticate();

            // If a user is authenticated, store them in the request
            if ($token) {
                $request->user = $token->getClaim('sub');
                return $next($request);
            }
        } catch (JWTException $e) {
            // Handle token parsing or authentication errors
            return $this->apiResponse('401','Unauthorized',['Unauthorized'],null);
        }

        return $this->apiResponse('401','Unauthorized',['Unauthorized'],null);
    }

}
