<?php

namespace App\Http\Controllers\api\hotel;

use App\Http\Controllers\Controller;
use App\Sys\Services\SupplierServices;

class HotelControllers extends Controller
{
    private $suppliers;
    private $config;

    public function __construct()
    {
        $this->suppliers = new SupplierServices();
        $this->config = config('Points');
    }

    public function search()
    {
        $supp =  $this->supplier();
        $prepared_data = $this->config['Search']['prepared_data'];
        $preparedData = [];
        foreach ($supp as $s) {
            $class = $prepared_data[$s]['class'];
            $method = $prepared_data[$s]['method'];
            if (class_exists($class) && method_exists($class, $method)) {
                $instance = new $class();
                //$preparedData[$s] = call_user_func_array([$instance, $method], [$data]);
                $preparedData[$s] = call_user_func_array([$instance, $method],[]);
            }
        }
        return $preparedData;

    }

    private function supplier()
    {
        $supp = $this->suppliers->getApiSupplier('hotel');

        return $supp->pluck('alias_name')->toArray();
    }
}
