<?php

namespace App\Http\Controllers\api;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Mail\forgitPassword;
use App\Models\Client;
use App\Models\Sessions;
use App\Models\OTP;
use App\Models\PasswordReset;
use App\Models\User;
use App\Sys\Services\SessionServices;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use PHPOpenSourceSaver\JWTAuth\JWTAuth;
use Auth;
use Validator;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Session;


class AuthCountroller extends Controller
{
    use ApiResponse;

    protected $jwt;
    private $session;

    public function __construct(JWTAuth $jwt)
    {
        $this->jwt = $jwt;
        $this->session = new SessionServices();
    }

    public function register(Request $request)
    {
        $req = Validator::make($request->all(), [
            'client_phone' => 'required|unique:mysql2.cl_client,client_phone',
            'client_email' => 'required|unique:mysql2.cl_client,client_email',
            'password' => 'required',
           // 'name_ar' => 'required',
            'name_en' => 'required',
            'otp_type' => 'required',
        ]);
        if ($req->fails()) {
            return $this->apiResponse(201, 'ValidatorErrors', $req->errors());
        }
        $serial = $this->getSerial();
        $client = new user();
        $client->client_phone = $request->input('client_phone');
        $client->password = bcrypt($request->input('password'));
        $client->serial_num = $serial;
        $client->enable = 1;
        $client->client_email = $request->input('client_email');
        $client->client_name_ar = $request->input('name_ar');
        $client->client_name_en = $request->input('name_en');
        $client->client_country = $request->input('guestNationality');
        $client->special = 1;
        $client->otp_type = $request->input('otp_type');
        $client->notes = 'test';
        $client->created = Carbon::now();
        $client->modified = Carbon::now();
        if ($client->save()) {
            $otp = new OTP();
            $otp->otp = $this->genrateOTP();
            $otp->user_id = $client->id;
            $otp->type = 'login';
            $otp->expired = Carbon::now()->addHours(2);
            $otp->save();
            $data = ['id' => $client->id];
            return $this->apiResponse(200, 'Register successfully', null, $data);
        }
        return $this->apiResponse(201, 'Register ُErrors ', ['please try again']);

    }

    public function regiestOTP(Request $request)
    {
        $req = Validator::make($request->all(), [
            'id' => 'required',
            'otp' => 'required',
        ]);
        if ($req->fails()) {
            return $this->apiResponse(201, 'ValidatorErrors', $req->errors());
        }
        $otp = OTP::where([
            ['otp', '=', $request->otp],
            ['user_id', '=', $request->id],
            ['expired', '>=', Carbon::now()],
        ])->orderBy('id','desc')->first();

        if (!empty($otp)) {
            $otp->done = 1;
            $otp->save();
            $user = User::find($otp->user_id);
            if (!empty($user)) {
                if ( $token = Auth::guard('api')->login($user)) {
                    $tokenGues = [
                        'token' => 'bearer '. $token,
                        'client_id' => $user->id
                    ];
                   // $saveData = $this->saveGuest($tokenGues);
                    $saveData = $this->session->addSession($tokenGues['token'],true);
                    $getData =  [
                        'name' => $user->client_name_en,
                        'phone' => $user->client_phone,
                        'token' => 'bearer '. $token,
                        'otp'=>true,
                        'ex' => $saveData->exp_time,
                    ];
                    return $this->apiResponse(200, 'data Users', null, $getData);
                }
            }
        }
        return $this->apiResponse(201, 'Errors', 'invalid otp code');
    }

    public function resendOTP($id = 0)
    {
        $otp = OTP::where([
            ['user_id','=', $id],
            ['expired', '>=', Carbon::now()],
        ])->first();

        if (!empty($otp)) {
            $otp->otp = 2222;
            $otp->save();
            return $this->apiResponse(200, 'Done Change',['id'=>$id]);
        }

        return $this->apiResponse(201, 'otp Errors',"can't change");
    }

    public function updatedUser(Request $request)
    {
        $req = Validator::make($request->all(), [
            'client_phone' => 'required|unique:mysql2.cl_client,client_phone,' . Auth()->guard('api')->user()->id,
            'client_email' => 'required|unique:mysql2.cl_client,client_email,' . Auth()->guard('api')->user()->id,
            //'name_ar' => 'required',
           'name_en' => 'required',
           // 'otp_type' => 'required',
        ]);
        if ($req->fails()) {
            return $this->apiResponse(201, 'ValidatorErrors', $req->errors());
        }

        $user = User::find(Auth()->guard('api')->user()->id);
        $user->client_phone = $request->input('client_phone');
        $user->client_email = $request->input('client_email');
        //$user->client_name_ar = $request->input('name_ar');
        $user->client_name_en = $request->input('name_en');
        //$user->otp_type = $request->input('otp_type');
        if ($user->save()) {
            return $this->apiResponse(200, 'updated successfully', null, null);
        }
        return $this->apiResponse(201, 'Please try againe after some times', ['Please try againe after some times'], null);

    }

    public function me()
    {
        if(Auth()->guard('api')->check())
        {
            $user = Auth()->guard('api')->user();
            return $this->apiResponse(200, 'updated successfully', null, $user);
        }
        return $this->apiResponse(201, 'User Not Authentication', ['Please make login first'], null);
    }

    public function resetPassword(Request $request)
    {
        $req = Validator::make($request->all(), [
            'client_email' => 'required_without:client_phone|email',
            'client_phone' => 'required_without:client_email',
        ]);
        if ($req->fails()) {
            return $this->apiResponse(201, 'ValidatorErrors', $req->errors());
        }
        $email = $request->input('client_email');
        $phone = $request->input('client_phone');

        $check = User::when($email, function ($query, $email) {
            return $query->where('client_email', $email);
        })->when($phone, function ($query, $phone) {
            return $query->where('client_phone', $phone);
        })->first();

        if (!empty($check)) {
            if ($check->otp_type == 'email') {
                if ($check->client_email != null) {
                    $data = [
                        'name' => $check->client_name_ar,
                        'code' => $this->getCodeNumber(),
                        'verification' => $check->client_email,
                        'user_id' => $check->id,
                    ];

                    if ($this->SaveObtCode($data)) {
                       // Mail::to($check->client_email)->send(new forgitPassword($data));
                        return $this->apiResponse(200, 'Send Obt check Your mail', null, ['verification'=>$check->client_email]);
                    }

                }
                return $this->apiResponse(201, 'Please try againe after some times', ['verification'=>['Please try againe after some times']], null);

            } else {
                $code = $this->getCodeNumber();
                $data = [
                    'name' => $check->client_name_en,
                    'code'=>$this->getCodeNumber(),
                    //'code' => 111111,
                    'verification' => $check->client_phone,
                    'user_id' => $check->id,
                ];
                if ($this->SaveObtCode($data)) {
                    return $this->apiResponse(200, 'Send Obt check sms', null,['verification'=>$check->client_phone]);
                }
                return $this->apiResponse(201, 'Please try againe after some times', ['verification'=>['Please try againe after some times']], null);

            }

        }
        return $this->apiResponse(201, 'NoT Found', ['client_email'=>['email OR Phone Not Found']], null);
    }

    public function forgetPasswordReOTP($verification)
    {
        $re = PasswordReset::where([
            ['verification', $verification],
            ['used', 0]
        ])->first();

        if (!empty($re)) {
         //$code = $this->getCodeNumber();
            $code = 2222;
            $re->obt =2222;
            $re->ex = Carbon::now()->addHours(2);
            $re->save();
            $user = User::find($re->user_id);
            $data = [
                'name' => $user->client_name_en,
                'code' => $this->getCodeNumber(),
                'verification' => $re->verification,
                'user_id' => $user->id,
            ];
            // check phone or maill
            // send mail or phone
            // Mail::to($check->client_email)->send(new forgitPassword($data));
            return $this->apiResponse(200, 'Send Obt check Your mail', null, ['verification'=>$re->verification]);
        }
        return $this->apiResponse(201, 'NoT Found', ['verification'=>['verification Not Found']], null);
    }

    public function obtCode(Request $request)
    {
        $obt = $request->input('otp');
        $va = $request->input('verification');
        $obt = PasswordReset::where([
            ['obt', $obt],
            ['verification', $va],
            ['used', 0],
            ['ex', '>=', Carbon::now()]
        ])->orderBy('id','desc')->first();

        if (!empty($obt)) {
            $obt->used = 1;
            $obt->save();
            return $this->apiResponse(200, 'OTP Checked successfully', null, ['id' => $obt->user_id]);
        }
        return $this->apiResponse(201, 'OTP Expired or Errors ', ['otp Expired or Errors '], null);
    }

    public function updatedPassword(Request $request)
    {
        $req = Validator::make($request->all(), [
            'id' => 'required',
            'password' => 'required|min:3|max:100|confirmed',
        ]);
        if ($req->fails()) {
            return $this->apiResponse(201, 'ValidatorErrors', $req->errors());
        }

        $user = User::find($request->input('id'));
        $user->password = bcrypt($request->input('password'));
        if ($user->save())
            return $this->apiResponse(200, 'change password successfully ', null, null);

        return $this->apiResponse(201, 'Errors', ['try agine']);
    }


    private function getCodeNumber()
    {
      //  return random_int(100000, 999999);
        return 1111;
    }

    private function SaveObtCode($data)
    {
        $obt = new PasswordReset();
        $obt->verification = $data['verification'];
        $obt->obt = $data['code'];
        $obt->ex = Carbon::now()->addHours(2);
        $obt->user_id = $data['user_id'];
        return $obt->save();
    }

    public function login(Request $request)
    {

        $req = Validator::make($request->all(), [
            'client_phone' => 'required',
            'password' => 'required',
        ]);
        if ($req->fails()) {
            return $this->apiResponse(201, 'ValidatorErrors', $req->errors());
        }

        $credentials = $request->only('client_phone', 'password');
        if ($token =  \Illuminate\Support\Facades\Auth::guard('api')->attempt($credentials)) {
            return $this->respondWithToken($token);
        }
        return $this->apiResponse(401, 'Unauthorized');
    }

    public function guest(Request $request)
    {
        if(Auth()->guard('api')->check())
        {
            $token = Auth::guard('api')->getToken();
            $bearerToken = 'bearer '.$token;
            $return = $this->session->addSession($bearerToken,false);
            $getData = $this->UserData($token, $return);
            return $this->apiResponse(200, 'same users', null, $getData);
        }
        if ($request->client_phone && $request->password) {
            $data = [
                'client_phone' => $request->client_phone,
                'password' => $request->password,
            ];
            $req = Validator::make($data, [
                'client_phone' => 'required',
                'password' => 'required',
            ]);
            if ($req->fails()) {
                return $this->apiResponse(201, 'ValidatorErrors', $req->errors());
            }

            if ($token = Auth::guard('api')->attempt($data)) {
                $user =  Auth::guard('api')->user();
                $tokenGues = [
                    'token' => 'bearer '.$token,
                ];
                if ($request->token != null) {
                    $tokenGues['oldToken'] = $request->token;
                    $return = $this->session->updatedToken($tokenGues);
                    $getData = $this->UserData($token, $return);
                    return $this->apiResponse(200, 'data Users', null, $getData);
                }
                $saveData = $this->session->addSession($tokenGues['token'],false);
                $getData = $this->UserData($token, $saveData);
                return $this->apiResponse(200, 'data Users', null, $getData);
            }
            return $this->apiResponse(201, 'data Users', ['invalid phone or password'], null);
        }
        if ($request->has('token') && $request->token != null) {

            $token = $request->token;
            $saveData =  $this->session->addSession($token,false);
            return $this->apiResponse(200, 'guest Data', null,
                ['token' => $saveData->token, 'ex' => $saveData->exp_time, 'id' => $saveData->id]);

        }
        $token = $this->guestToken();
        $saveData = $this->session->addSession($token,true);
        return $this->apiResponse(200, 'guest Data', null,
            ['token' => $saveData->token, 'ex' => $saveData->exp_time, 'id' => $saveData->id]);
    }

    protected function UserData($token, $guest)
    {
        $user = Auth()->guard('api')->user();
        //$user = auth()->user();
        $data = [
            'name' => $user->client_name_en,
            'phone' => $user->client_phone,
            'id' => $user->id,
            'token' => 'bearer '.$token,
            'otp'=>$this->LoginOtp($user->id),
            'ex' => $guest->exp_time,
        ];
        return $data;
    }
    public function LoginOtp($id)
    {
        $otp = OTP::where([
            ['user_id', $id],
            ['type','login']
        ])->orderBy('id','desc')->first();

        if (!empty($otp)) {
            if($otp->done == 1)
                return true;


            $otp->expired = Carbon::now()->addHours(2);
            $otp->otp = $this->genrateOTP();
            $otp->save();
            return false;

        }
        $newOtp = new OTP();
        $newOtp->otp = $this->genrateOTP();
        $newOtp->user_id = $id;
        $newOtp->type = 'login';
        $newOtp->expired = Carbon::now()->addHours(2);
        $newOtp->save();
        return false;

    }
    private function getSerial()
    {
        $serial = User::latest()->first();
        return !empty($serial) ? $serial->serial_num + 1 : 1;
    }
    private function guestToken()
    {
        return uniqid() . time() . Str::random(40);
    }

    public function genrateOTP()
    {
        return 1111;
    }
}
