<?php

namespace Modules\Hotel\Sys\ServicesProvidor\TBO;

use App\Sys\Services\SupplierServices;
use GuzzleHttp\Client;

trait TBOConnection
{

    public function TBO($method = "get", $endPoint, $parameter = null)
    {
        $client = new Client();
        if($cred = $this->getCredentials())
        {

            $point = $cred['url'] . '/' . $endPoint;
            $auth = [$cred['username'] ,$cred['password'] ];
            $options = [
                'headers' => ['Content-Type' => 'application/json'],
                'auth' => $auth,
            ];

            if (in_array(strtoupper($method), ['POST', 'PUT'])) {
                $options['json'] = $parameter;
            } else {
                $options['query'] = $parameter;
            }
            $response = $client->request($method, $point, $options);

            return json_decode($response->getBody(), true);
        }
        return false;

    }

    private function getCredentials()
    {
        $spSupplier = new SupplierServices();
        $credentials = $spSupplier->getCredentials('tbo');
        if(!empty($credentials))
            return ['url'=>$credentials->hotel_api_url,'username'=>$credentials->hotel_api_username,'password'=>$credentials->hotel_api_password];

        return false;
    }
}
