<?php

namespace Modules\Hotel\Sys\Services;

use App\Models\Result;
use App\Sys\Services;
use App\Sys\Services\SessionServices;
use App\Sys\Services\staticData\cities\CitiesNamedServices;
use App\Sys\Services\SupplierServices;
use PhpParser\Node\Expr\Empty_;
use Validator;

class BookingServices extends Services
{
    private $config;
    private $session;
    private $suppliers;

    public function __construct()
    {
        $this->config = config('hotel');
        $this->session = new SessionServices();
        $this->suppliers = new SupplierServices();
    }

    public function getRooms($data)
    {
        $session_id = $data['session_id'] ?? null;
        $supp = $this->supplier();
        if ($session_id == null && !empty($data['required_fields']) && in_array($data['required_fields']['company'], $supp)) {
            $this->setError('Not Found session_id :)');
            return false;
        }


        // $h = Result::where([['guest_id', $data['session_id']], ['type', 'hotel']])->first();
        //$search = json_decode($h->search, true);
        $prepared_data = $this->config['Rooms']['prepared_data'][$data['required_fields']['company']];
        $class = $prepared_data['class'];
        $method = $prepared_data['method'];
        if (class_exists($class) && method_exists($class, $method)) {
            $instance = new $class();
            $preparedData = call_user_func_array([$instance, $method], [$data]);
        }
        if (!empty($preparedData)) {
            $search = $this->config['Rooms']['get_data'][$data['required_fields']['company']];
            $class = $search['class'];
            $method = $search['method'];
            if (class_exists($class) && method_exists($class, $method)) {
                $instance = new $class();
                $rooms = call_user_func_array([$instance, $method], [$preparedData]);
                if ($rooms['status'] == true) {
                    return $rooms['data'];
                }
                $this->setError($rooms['data']);
                return false;
            }
        }

        $this->setError(['this Company name Not Allowed']);
        return false;
        /*
        return $preparedData;
        if (!empty($search)) {
            $search['hotel_code'] = $data['hotel_code'];
            if (in_array($data['company_name'], $supp)) {
                $prepared_data = $this->config['Rooms']['prepared_data'][$data['company_name']];
                $class = $prepared_data['class'];
                $method = $prepared_data['method'];
                if (class_exists($class) && method_exists($class, $method)) {
                    $instance = new $class();
                    $preparedData = call_user_func_array([$instance, $method], [$search]);
                }
                if (!empty($preparedData)) {
                    $search = $this->config['Rooms']['get_data'][$data['company_name']];
                    $class = $search['class'];
                    $method = $search['method'];
                    if (class_exists($class) && method_exists($class, $method)) {
                        $instance = new $class();
                        $rooms = call_user_func_array([$instance, $method], [$preparedData]);
                        $rooms['session_id'] = $h->guest_id;
                        return $rooms;
                    }
                }
            }
        }
        */


    }

    public function getHotelDetials($data)
    {
        $session_id = $data['session_id'] ?? null;
        $supp = $this->supplier();
        if ($session_id == null && !empty($data['required_fields']) && in_array($data['required_fields']['company'], $supp)) {
            $this->setError('Not Found session_id :)');
            return false;
        }
        $search = $this->config['Rooms']['hotel_detials'][$data['required_fields']['company']];
        $class = $search['class'];
        $method = $search['method'];
        if (class_exists($class) && method_exists($class, $method)) {
            $instance = new $class();
            $hotel = call_user_func_array([$instance, $method], [$data]);
            if ($hotel['status'] == true) {
                return $hotel['data'];
            }
            $this->setError($hotel['data']);
            return false;
        }
        $this->setError(['this Company name Not Allowed']);
        return false;
    }

    public function preBooking($data)
    {

        $session_id = $data['session_id'] ?? null;
        $supp = $this->supplier();
        if ($session_id == null && !empty($data['required_fields']) && in_array($data['required_fields']['company'], $supp)) {
            $this->setError('Not Found session_id :)');
            return false;
        }

        $prepared_data = $this->config['PreBooking'][$data['required_fields']['company']];
        $class = $prepared_data['class'];
        $method = $prepared_data['method'];
        if (class_exists($class) && method_exists($class, $method)) {
            $instance = new $class();
            $preparedData = call_user_func_array([$instance, $method], [$data]);
            if ($preparedData['status'] == true) {
                return $preparedData['data'];
            }
            $this->setError($preparedData['data']);
            return false;

        }

        $this->setError(['this Company name Not Allowed']);
        return false;
    }

    public function booking($data)
    {

        $session_id = $data['session_id'] ?? null;
        $supp = $this->supplier();
        if ($session_id == null && !empty($data['required_fields']) && in_array($data['required_fields']['company'], $supp)) {
            $this->setError('Not Found session_id :)');
            return false;
        }

        if (in_array($data['required_fields']['company'], $supp)) {
            $prepared_data = $this->config['Booking'][$data['required_fields']['company']];
            $class = $prepared_data['class'];
            $method = $prepared_data['method'];
            if (class_exists($class) && method_exists($class, $method)) {
                $instance = new $class();
                return $preparedData = call_user_func_array([$instance, $method], [$data]);
            }
        }

        $this->setError(['this Company name Not Allowed']);
        return false;

    }

    public function mappingData($session)
    {

        $data = $this->session->getFirstRueslteData($session);
        $property = [];

        if ($data['status'] == true) {
            foreach ($data['data'] as $re) {
                $result = json_decode($re['result'], true);
                $property = array_merge($property, $result['data']);
            }
        } else {

            $property = $data['data']['data'][0];
        }
        $add = new Result();
        $add->guest_id = $session;
        $add->is_active = 1;
        $add->type = 'hotel';
        $add->status = $data['status'] == true ? 1 : 0;
        $add->properties = json_encode($property);
        $add->save();
        return $this->session->updatedSe($session);
    }

    private function supplier()
    {
        $supp = $this->suppliers->getApiSupplier('hotel');

        return $supp->pluck('alias_name')->toArray();
    }

}
