<?php

namespace Modules\Hotel\Providers;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Modules\Hotel\App\Events\SaveFinshedHotel;
use Modules\Hotel\App\Events\SearchMR;
use Modules\Hotel\App\Events\SearchTBO;
use Modules\Hotel\App\Listeners\SaveFinshedListener;
use Modules\Hotel\App\Listeners\SearchMRListener;
use Modules\Hotel\App\Listeners\SearchTBOListener;

class EventServiceProvider extends ServiceProvider
{
    protected $listen = [
        SearchTBO::class => [
            SearchTBOListener::class,
        ],
        SearchMR::class=>[
            SearchMRListener::class
        ],
        SaveFinshedHotel::class =>[
            SaveFinshedListener::class
        ],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

    }

}
