<?php

namespace Modules\Hotel\Http\Controllers;

use App\ApiResponse;
use App\Models\Sessions;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Hotel\App\Events\SearchMR;
use Modules\Hotel\App\Events\SearchTBO;
use Modules\Hotel\Sys\Services\BookingServices;
use Modules\Hotel\Sys\Services\HotelServices;
use Modules\Hotel\Sys\ServicesProvidor\MR\MRServices;

class HotelController extends Controller
{
    use ApiResponse;

    private $services;
    private $booking;

    public function __construct()
    {
        $this->services = new HotelServices();
        $this->booking = new BookingServices();
    }

    public function search()
    {
        if ($data = $this->services->search(request()->all()))
            return $this->apiResponse(200, 'data', null, $data);


        $errors = $this->services->errors();
        return $this->apiResponse(201, 'error', $errors, null);
    }

    public function fillter()
    {
        if ($data = $this->services->fillter(request()->all()))
            return $this->apiResponse(200, 'data', null, $data);

        $errors = $this->services->errors();
        return $this->apiResponse(201, 'error', $errors, null);
    }

    public function getRooms(Request $request)
    {
        $jsonContent = $request->getContent();

        if (empty($jsonContent))
            return $this->apiResponse(400, 'Bad Request', 'JSON content is empty', null);


        $updatedJsonData = json_decode($jsonContent, true);
        if ($data = $this->booking->getRooms($updatedJsonData))
            return $this->apiResponse(200, 'room', null, ['data' => $data, 'session_id' => $updatedJsonData['session_id']]);


        $errors = $this->booking->errors();
        return $this->apiResponse(201, 'error', $errors, null);
    }

    public function hotelDetials(Request $request)
    {

        $jsonContent = $request->getContent();

        if (empty($jsonContent))
            return $this->apiResponse(400, 'Bad Request', 'JSON content is empty', null);


        $updatedJsonData = json_decode($jsonContent, true);
        if ($data = $this->booking->getHotelDetials($updatedJsonData))
            return $this->apiResponse(200, 'Hotel', null, ['data' => $data, 'session_id' => $updatedJsonData['session_id']]);


        $errors = $this->booking->errors();
        return $this->apiResponse(201, 'error', $errors, null);
    }

    public function preBooking(Request $request)
    {

        $jsonContent = $request->getContent();

        if (empty($jsonContent))
            return $this->apiResponse(400, 'Bad Request', 'JSON content is empty', null);


        $updatedJsonData = json_decode($jsonContent, true);

        if ($data = $this->booking->preBooking($updatedJsonData))
            return $this->apiResponse(200, 'Pre Book', null,['data' => $data, 'session_id' => $updatedJsonData['session_id']]);


        $errors = $this->services->errors();
        return $this->apiResponse(201, 'error', $errors, null);
    }

    public function booking(Request $request)
    {
        $jsonContent = $request->getContent();

        if (empty($jsonContent))
            return $this->apiResponse(400, 'Bad Request', 'JSON content is empty', null);


        $updatedJsonData = json_decode($jsonContent, true);
        return $data = $this->booking->booking($updatedJsonData);
        if ($data = $this->booking->booking($updatedJsonData))
            return $this->apiResponse(200, 'room', null, ['data' => $data['data'], 'session_id' => $data['session_id']]);


        $errors = $this->services->errors();
        return $this->apiResponse(201, 'error', $errors, null);

    }

    public function test()
    {

        return $data = $this->booking->mappingData(263);
        $pro = [];
        foreach ($data as $d) {
            $pro = array_merge($pro, $d['data']);
        }
        return $pro;
        /*
        $session = $this->services->testSearch();
        return $this->apiResponse(200,'session id ',null,['session_id'=>$session]);
        */
    }
}
